% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number-format-functions.R
\name{fmt_percent}
\alias{fmt_percent}
\title{Format numbers as percent}
\usage{
fmt_percent(digits = 1, format = "f", ...)
}
\arguments{
\item{digits}{How many digits to print.}

\item{format, ...}{Passed into \code{\link[=formatC]{formatC()}}.}
}
\value{
An object you can pass into \code{\link[=number_format]{number_format()}}.
}
\description{
\code{fmt_} functions are designed to work with \code{\link[=number_format]{number_format()}}.
}
\examples{

jams$Sugar <- c(
  "Sugar content",
  0.4, 0.35, 0.45
)
set_number_format(
  jams, -1, "Sugar",
  fmt_percent(1)
)

}
\seealso{
Other format functions: 
\code{\link{fmt_pretty}()}
}
\concept{format functions}
