% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.R
\name{infomap.community}
\alias{infomap.community}
\title{Infomap community finding}
\usage{
infomap.community(
  graph,
  e.weights = NULL,
  v.weights = NULL,
  nb.trials = 10,
  modularity = TRUE
)
}
\arguments{
\item{graph}{The input graph. Edge directions will be taken into account.}

\item{e.weights}{If not \code{NULL}, then a numeric vector of edge weights.
The length must match the number of edges in the graph.  By default the
\sQuote{\code{weight}} edge attribute is used as weights. If it is not
present, then all edges are considered to have the same weight.
Larger edge weights correspond to stronger connections.}

\item{v.weights}{If not \code{NULL}, then a numeric vector of vertex
weights. The length must match the number of vertices in the graph.  By
default the \sQuote{\code{weight}} vertex attribute is used as weights. If
it is not present, then all vertices are considered to have the same weight.
A larger vertex weight means a larger probability that the random surfer
jumps to that vertex.}

\item{nb.trials}{The number of attempts to partition the network (can be any
integer value equal or larger than 1).}

\item{modularity}{Logical scalar, whether to calculate the modularity score
of the detected community structure.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{infomap.community()} was renamed to \code{\link[=cluster_infomap]{cluster_infomap()}} to create a more
consistent API.
}
\keyword{internal}
