% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inRt.R
\name{incRt}
\alias{incRt}
\title{Calculation of temperature average and variance for customised
time windows}
\usage{
incRt(
  data,
  temp.name,
  limits = NULL,
  coor = NULL,
  activity.times = FALSE,
  civil.twilight = FALSE,
  time.zone = NULL,
  ...
)
}
\arguments{
\item{data}{data frame containing a time-series vector of 1's and 0's (incubation scores), 
where "1"
means "incubating individual inside nest" and "0" means "incubating individual 
outside the nests". This vector, 
under the name of \code{incR_score}, is provided by \code{\link{incRscan}} in the 
first object of the returned list. A column named "date" is needed to refer to daily
calculations.}

\item{temp.name}{(character object) name of the column containing temperature data 
in data.}

\item{limits}{vector of length 2 giving the time limits for calculations. For example,
'c(6,20)' would calculate temperature averages and variances for two time periods, from 6 to 20
and from 20 to 6 of the next day. 'civil.twilight' and 'activity.times' must be
FALSE to allow the use of 'limits'.}

\item{coor}{coordinates for the location where temperature was recorded,
formatted as decimal degrees N/S, decimal degrees E/W.
When 'civil.twilight' is TRUE, 'coor' allows the user to define sunrise and sunset times
based on the \code{\link[suncalc:getSunlightTimes]{suncalc::getSunlightTimes()}} function (in \code{suncalc} package).}

\item{activity.times}{TRUE or FALSE. Set as TRUE when time periods for calculation
are defined by \code{\link{incRact}}. Data must contain a column named 
'incR_score' for the use of \code{\link{incRact}}.}

\item{civil.twilight}{TRUE or FALSE. Set as TRUE when time periods for calculation
are to be defined by civil twilight times - calculated using \code{\link[suncalc:getSunlightTimes]{suncalc::getSunlightTimes()}}. 
If 'civil.twilight = TRUE', 'coor' and 'time.zone' need to be specified.}

\item{time.zone}{time zone for \code{\link[suncalc:getSunlightTimes]{suncalc::getSunlightTimes()}} dawn and dusk calculations.}

\item{...}{use parameters in \code{\link{incRact}} if \emph{activity.times} = TRUE.}
}
\value{
a data frame containing temperature means and variance for the defined time 
window.
}
\description{
Calculation of temperature average and variation between two customised
time periods per day. Time windows can be defined by the user using the \code{limits} argument,
defined by bird activity time (using the \code{activity.times} parameter) or set according to
twilight times if coordinates are provided (\code{coor}).
}
\examples{
# loading example data
data(incR_procdata)

# calculation based on chosen times from 6am to 7pm and 7pm to 6am
incRt (data=incR_procdata, 
        temp.name="temperature",
        limits=c(6,19), 
        coor=NULL, 
        civil.twilight=FALSE, 
        activity.times=FALSE,
        time.zone=NULL)
        
# calculation based on activity times
incRt (data=incR_procdata, 
        temp.name="temperature", 
        limits=NULL, 
        coor=NULL, 
        civil.twilight=FALSE, 
        activity.times=TRUE,
        time.zone=NULL,
        time_column="time",             # extra argument needed for incRact
        vector.incubation="incR_score") # extra argument needed for incRact
        
# calculation based on civil twilight
incRt (data=incR_procdata, 
        temp.name="temperature",
        limits=NULL, 
        coor=c(42,0.89), 
        civil.twilight=TRUE, 
        activity.times=FALSE,
        time.zone="GMT")
}
\seealso{
\code{\link{incRprep}} \code{\link{incRscan}} \code{\link{incRact}}
\code{\link[suncalc:getSunlightTimes]{suncalc::getSunlightTimes()}}
}
\author{
Pablo Capilla-Lasheras
}
