% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devtools.R
\name{roxy_tag_rd.roxy_tag_ireturn}
\alias{roxy_tag_rd.roxy_tag_ireturn}
\title{Support for \verb{@ireturn} tags}
\usage{
\method{roxy_tag_rd}{roxy_tag_ireturn}(x, base_path, env)
}
\arguments{
\item{x}{The tag}

\item{base_path}{Path to package root directory.}

\item{env}{Environment in which to evaluate code (if needed)}
}
\value{
an \code{roxygen2::rd_section} (see \code{roxygen2} documentation)
}
\description{
The \verb{@ireturn <description>} tag can be used in \code{roxygen2} documentation
of a function to describe a dataframe return value. The function must be using
\code{interfacer::ireturn} to validate the output dataframe parameter format. The
\verb{@ireturn} tag will then generate documentation about the type of dataframe
the function is returning.
}
\examples{

# An example function definition:
fn_definition <- "
#' This is a title
#'
#' This is the description.
#'
#' @md
#' @ireturn the output dataframe
#' @export
f <- function() {
  interfacer::ireturn(iris,
    interfacer::iface(
      Sepal.Length = numeric ~ \"the Sepal.Length column\",
      Sepal.Width = numeric ~ \"the Sepal.Width column\",
      Petal.Length = numeric ~ \"the Petal.Length column\",
      Petal.Width = numeric ~ \"the Petal.Width column\",
      Species = enum(`setosa`,`versicolor`,`virginica`) ~ \"the Species column\",
      .groups = NULL
    ))
}
"

# For this example we manually parse the function specification in `fn_definition`
# creating a .Rd block - normally this is done by `roxygen2` which then
# writes this to an .Rd file. This function is not intended to be used
# outside of a call to `devtools::document`.

tmp = roxygen2::parse_text(fn_definition)
print(tmp[[1]])

}
\concept{document}
