% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_html2cms.R
\name{convert_html2cms}
\alias{convert_html2cms}
\title{Convert a HTML file into a HTML block to be copied and pasted for CMS.}
\usage{
convert_html2cms(
  in_text,
  full_html = the$full_html \%||\% FALSE,
  tag = the$tag \%||\% "body",
  id = the$id,
  remove_script = the$remove_script \%||\% FALSE
)
}
\arguments{
\item{in_text}{character. Character vector representing the HTML file to convert.}

\item{full_html}{logical. If TRUE, produce complete html output,
convenient when drafting a document. When this option is enabled, tag and
id and remove_script options are silently ignored.}

\item{tag}{character. Outer-most tag for the resulting HTML snippet.}

\item{id}{character. id attribute for the outer-most tag.}

\item{remove_script}{logical. If TRUE, script tags are all stripped out.}
}
\value{
character. HTML block.
}
\description{
Convert a HTML file into a HTML block to be copied and pasted for CMS.
}
