% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_dimensions.R
\name{estimate_dimensions}
\alias{estimate_dimensions}
\title{Estimates Dimensions using Several State-of-the-art Methods}
\usage{
estimate_dimensions(
  data,
  sample_size,
  EGA_args = list(corr = "auto", uni.method = "louvain", model = "glasso",
    consensus.method = "most_common", plot.EGA = FALSE),
  FF_args = list(maximum_factors = 8, PA_correlation = "cor"),
  FSPE_args = list(maxK = 8, rep = 1, method = "PE", pbar = FALSE),
  NEST_args = list(iterations = 1000, maximum_iterations = 500, alpha = 0.05, convergence
    = 0.00001),
  PA_args = list(fm = "minres", fa = "both", cor = "cor", n.iter = 20, sim = FALSE, plot
    = FALSE)
)
}
\arguments{
\item{data}{Matrix or data frame.
Either a dataset with all numeric values
(rows = cases, columns = variables) or
a symmetric correlation matrix}

\item{sample_size}{Numeric (length = 1).
If input into \code{data} is a correlation matrix,
then specifying the sample size is required}

\item{EGA_args}{List.
List of arguments to be passed along to
\code{\link[EGAnet]{EGA}}.
Defaults are listed}

\item{FF_args}{List.
List of arguments to be passed along to
\code{\link[latentFactoR]{factor_forest}}.
Defaults are listed}

\item{FSPE_args}{List.
List of arguments to be passed along to
\code{\link[fspe]{fspe}}.
Defaults are listed}

\item{NEST_args}{List.
List of arguments to be passed along to
\code{\link[latentFactoR]{NEST}}.
Defaults are listed}

\item{PA_args}{List.
List of arguments to be passed along to
\code{\link[psych]{fa.parallel}}.
Defaults are listed}
}
\value{
Returns a list containing:

\item{dimensions}{Dimensions estimated from each method}

A list of each methods output (see their respective functions for their outputs)
}
\description{
Estimates dimensions using Exploratory Graph Analysis
(\code{\link[EGAnet]{EGA}}),
Empirical Kaiser Criterion (\code{\link[latentFactoR]{EKC}}),
Factor Forest (\code{\link[latentFactoR]{factor_forest}}),
Exploratory Factor Analysis with out-of-sample prediction (\code{\link[fspe]{fspe}}),
Next Eigenvalue Sufficiency Test (\code{\link[latentFactoR]{NEST}}), and
parallel analysis (\code{\link[psych]{fa.parallel}})
}
\examples{
# Generate factor data
two_factor <- simulate_factors(
  factors = 2, # factors = 2
  variables = 6, # variables per factor = 6
  loadings = 0.55, # loadings between = 0.45 to 0.65
  cross_loadings = 0.05, # cross-loadings N(0, 0.05)
  correlations = 0.30, # correlation between factors = 0.30
  sample_size = 1000 # number of cases = 1000
)

\dontrun{
# Estimate dimensions
estimate_dimensions(two_factor$data)}

}
\author{
Maria Dolores Nieto Canaveras <mnietoca@nebrija.es>,
Alexander P. Christensen <alexpaulchristensen@gmail.com>,
Hudson Golino <hfg9s@virginia.edu>,
Luis Eduardo Garrido <luisgarrido@pucmm.edu>
}
