# lightsf - Collection of georeferenced and spatial datasets from different domains
# Version 0.1.0
# Copyright (C) 2025 Ingrid Romero Pinilla
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# bacprodxy_pts


library(testthat)

# Test 1: Confirm the object is a data.frame
test_that("bacprodxy_pts is a data.frame", {
  expect_s3_class(bacprodxy_pts, "data.frame")
})

# Test 2: Confirm it has exactly 2 columns
test_that("bacprodxy_pts has 2 columns", {
  expect_equal(length(bacprodxy_pts), 2)
})

# Test 3: Confirm it has exactly 25 rows
test_that("bacprodxy_pts has 25 rows", {
  expect_equal(nrow(bacprodxy_pts), 25)
})

# Test 4: Confirm column names are correct
test_that("bacprodxy_pts has correct column names", {
  expect_named(bacprodxy_pts, c("Longitude", "Latitude"))
})

# Test 5: Confirm column types are numeric
test_that("bacprodxy_pts columns have correct types", {
  expect_type(bacprodxy_pts$Longitude, "double")
  expect_type(bacprodxy_pts$Latitude, "double")
})
