% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_tree.R
\docType{data}
\name{sim_tree}
\alias{sim_tree}
\title{Simulated transmission tree}
\format{
A data frame with 373 rows and 6 columns:
\describe{
\item{group}{Character. The group to which the individual belongs.}
\item{id}{Character. Unique identifier for each individual in the study.}
\item{source}{Character. The ID of the individual who was the source of infection, if known. \code{NA} indicates an unknown source.}
\item{source_group}{Character. The group of the source individual. \code{NA} for unknown sources.}
\item{date_infection}{Numeric. The date of infection. Represented as the number of days since the start of the study.}
\item{date_onset}{Numeric. The date of onset of symptoms. Represented as the number of days since the start of the study.}
}
}
\source{
This dataset is simulated (see R package \code{o2groups}) and does not correspond to real-world data.
}
\usage{
sim_tree
}
\description{
This dataset represents a simulated transmission tree.
This simulation was generated using the R package \code{o2groups} (see \url{https://github.com/CyGei/o2groups} for more information).
Group \code{HCW} is assortative with a gamma coefficient of 2 and group \code{patient} is disassortative with a gamma coefficient of 1/1.25.
Suceptible group sizes were 100 and 350, respectively.
Code to reproduce the data below:

\if{html}{\out{<div class="sourceCode">}}\preformatted{pak::pak("CyGei/o2groups")
set.seed(123)
sim_tree <- o2groups::simulate_groups(
  duration = 100,
  group_n = 2,
  size = c(100, 350), # susceptible group sizes
  name = c("HCW", "patient"),
  gamma = c(2, 0.8), # assortativity coefficients
  intro_n = c(1, 3),
  r0 = c(2, 2),
  generation_time = c(0, 0.1, 0.2, 0.4, 0.2, 0.1, 0),
  incubation_period = sample(1:14, 1000, replace = TRUE)
)
}\if{html}{\out{</div>}}
}
\keyword{datasets}
