% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_data.R
\docType{data}
\name{sample_no_switching}
\alias{sample_no_switching}
\title{Sample Dataset Without Candidate Switching}
\format{
A data frame with 15 rows and 5 variables (same structure as \code{\link{sample_data}}).
}
\source{
Fictitious data
}
\usage{
sample_no_switching
}
\description{
A variant of \code{\link{sample_data}} in which candidates may run in multiple
elections, but always remain within the same political group. In other words,
they never switch between candidate list clusters, which makes the dataset
useful for testing continuity logic under stable group membership (verifying
that no cross-group transitions occur).
}
\examples{
# Basic inspection
str(sample_no_switching)

# Quick continuity diagram (basic and unformatted version)
\donttest{plot_continuity(sample_no_switching)}
}
\keyword{datasets}
