% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_helpers.R
\name{step_classification}
\alias{step_classification}
\alias{step_equal_interval}
\alias{step_quantile}
\alias{step_jenks}
\title{Step expressions with automatic classification}
\usage{
step_equal_interval(
  data = NULL,
  column,
  data_values = NULL,
  n = 5,
  palette = NULL,
  colors = NULL,
  na_color = "grey"
)

step_quantile(
  data = NULL,
  column,
  data_values = NULL,
  n = 5,
  palette = NULL,
  colors = NULL,
  na_color = "grey"
)

step_jenks(
  data = NULL,
  column,
  data_values = NULL,
  n = 5,
  palette = NULL,
  colors = NULL,
  na_color = "grey"
)
}
\arguments{
\item{data}{A data frame or sf object containing the data. If provided, data_values
will be extracted from \code{data[[column]]}. Either data or data_values must be provided.}

\item{column}{The name of the column to use for the step expression.}

\item{data_values}{A numeric vector of the actual data values used to calculate breaks.
If NULL and data is provided, will be extracted from \code{data[[column]]}.}

\item{n}{The number of classes/intervals to create. Defaults to 5.}

\item{palette}{A function that takes n and returns a character vector of colors.
If NULL and colors is also NULL, defaults to \code{viridisLite::viridis}.}

\item{colors}{A character vector of colors to use. Must have exactly n colors
for step classification functions. Either palette or colors should be provided, but not both.}

\item{na_color}{The color to use for missing values. Defaults to "grey".}
}
\value{
A list of class "mapgl_classification" containing the step expression and metadata.
}
\description{
These functions create step expressions using different classification methods,
similar to choropleth mapping in GIS software. They automatically calculate
break points and generate appropriate step expressions for styling map layers.
}
\details{
\describe{
\item{step_equal_interval()}{Creates equal interval breaks by dividing the data range into equal parts}
\item{step_quantile()}{Creates quantile breaks ensuring approximately equal numbers of observations in each class}
\item{step_jenks()}{Creates Jenks natural breaks using Fisher-Jenks optimization to minimize within-class variance}
}
}
\examples{
\dontrun{
# Texas county income data
library(tidycensus)
tx <- get_acs(geography = "county", variables = "B19013_001",
              state = "TX", geometry = TRUE)

# Using palette function (recommended)
eq_class <- step_equal_interval(data = tx, column = "estimate", n = 5,
                                palette = viridisLite::plasma)
# Or with piping
eq_class <- tx |> step_equal_interval("estimate", n = 5)

# Using specific colors
qt_class <- step_quantile(data = tx, column = "estimate", n = 3,
                         colors = c("red", "yellow", "blue"))

# Jenks natural breaks with default viridis
jk_class <- step_jenks(data = tx, column = "estimate", n = 5)

# Use in a map with formatted legend
maplibre() |>
  add_fill_layer(source = tx, fill_color = eq_class$expression) |>
  add_legend(
    legend_title = "Median Income",
    values = get_legend_labels(eq_class, format = "currency"),
    colors = get_legend_colors(eq_class),
    type = "categorical"
  )

# Compare different methods
print(eq_class, format = "currency")
print(qt_class, format = "compact", prefix = "$")
}

}
\seealso{
\code{\link[=interpolate_palette]{interpolate_palette()}} for continuous color scales
}
