% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.testmc.R
\name{plot.testmc}
\alias{plot.testmc}
\title{Plot function.}
\usage{
\method{plot}{testmc}(x, ...)
}
\arguments{
\item{x}{An object of class `testmc` or `global_envelope`.}

\item{...}{Ignored.}
}
\value{
Invisibly returns the ggplot object.
}
\description{
Plots objects of class `testmc`.
Supports global and local types, multiple marks, and fully customizable appearance via `layers` or `...`.
}
\section{Additional graphical customization}{

The object returned by \code{plot.testmc()} is a \code{ggplot} object. This means
that all standard graphical components from the \pkg{ggplot2} package (such as
layers, scales, and themes) can be added to the plot using the \code{+} operator.
This allows users to further customize labels, colors, axes, and the overall
appearance of the plot.
}

\examples{
\donttest{
 library(spatstat.geom)
 library(spatstat.random)
 library(spatstat.explore)
 library(spatstat.linnet)
 library(ggplot2)

#######################################
## 1. Planar point patterns (ppp)
#######################################

# Global mark correlation (real-valued marks)
X_ppp <- rpoispp(200)
marks(X_ppp) <- data.frame(m1 = runif(npoints(X_ppp), 1, 10))

tc_ppp1 <- testmc(X_ppp,
                   fun = mcorr.ppp,
                   fun_args = list(ftype = "stoyan", method = "density"))

plot(tc_ppp1) +
  labs(
    title = "Global mark correlation (ppp)",
    x = expression(r),
    y = "Observed / Envelope"
  ) +
  theme_minimal() +
  theme(
    plot.title = element_text(size = 14, face = "bold"),
    axis.title = element_text(size = 12),
    axis.text = element_text(size = 10),
    legend.title = element_text(size = 11),
    legend.text = element_text(size = 10)
  )

# Local mark correlation (real-valued marks)
X_ppp2 <- rpoispp(200)
marks(X_ppp2) <- data.frame(m1 = runif(npoints(X_ppp2), 1, 10))

tc_ppp2 <- testmc(X_ppp2,
                   fun = lmcorr.ppp,
                   fun_args = list(ftype = "stoyan", method = "density"))

plot(tc_ppp2[[1]]) +
  labs(
    title = "Local mark correlation (ppp)",
    x = expression(r),
    y = "Local correlation"
  ) +
  theme_classic() +
  theme(
    plot.title = element_text(size = 13, face = "bold"),
    axis.title = element_text(size = 12),
    axis.text = element_text(size = 10),
    legend.title = element_text(size = 11),
    legend.text = element_text(size = 10),
    legend.position = "right"
  )

plot(tc_ppp2) +
  labs(
    title = "Effective range",
    x = expression(r),
    y = "Id of significant points"
  ) +
  theme_classic() +
  theme(
    plot.title = element_text(size = 23, face = "bold"),
    axis.title = element_text(size = 12),
    axis.text = element_text(size = 20),
    legend.title = element_text(size = 21),
    legend.text = element_text(size = 30),
    legend.position = "right"
  )

#######################################
## 2. Linear network point patterns (lpp)
#######################################

X_lpp <- rpoislpp(40, simplenet)
marks(X_lpp) <- data.frame(m1 = runif(npoints(X_lpp), 1, 10))

tc_lpp1 <- testmc(X_lpp,
                  fun = mcorr.lpp,
                  fun_args = list(ftype = "stoyan", method = "density"))

plot(tc_lpp1) +
  labs(
    title = "Global mark correlation (lpp)",
    x = expression(r),
    y = "Observed / Envelope"
  ) +
  theme_bw() +
  theme(
    plot.title = element_text(size = 14, face = "bold"),
    axis.title = element_text(size = 12),
    axis.text = element_text(size = 10),
    legend.title = element_text(size = 11),
    legend.text = element_text(size = 10),
    legend.position = "top"
  )

# Local functional mark correlation (function-valued marks)
marks(X_lpp) <- data.frame(
  t1 = runif(npoints(X_lpp), 1, 10),
  t2 = runif(npoints(X_lpp), 1, 10)
)

tc_lpp2 <- testmc(X_lpp,
                  fun = lfmcorr,
                  fun_args = list(ftype = "stoyan", method = "density"))

plot(tc_lpp2[[1]]) +
  labs(
    title = "Local functional mark correlation (lpp)",
    x = expression(r),
    y = "Local correlation"
  ) +
  theme_light() +
  theme(
    plot.title = element_text(size = 13, face = "bold"),
    axis.title = element_text(size = 12),
    axis.text = element_text(size = 10),
    legend.title = element_text(size = 11),
    legend.text = element_text(size = 10),
    legend.position = "bottom"
  )

}
}
\author{
Mehdi Moradi \email{m2.moradi@yahoo.com}
}
