% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icd_compact_to_full.R
\name{icd_compact_to_full}
\alias{icd_compact_to_full}
\title{Convert ICD Compact Codes to Full Codes}
\usage{
icd_compact_to_full(x, icdv, dx)
}
\arguments{
\item{x}{Character vector}

\item{icdv}{Integer vector of allowed ICD versions. Use \code{9L} and/or
\code{10L}. Defaults to both.}

\item{dx}{Integer vector indicating allowed code type(s): \code{1L} for
diagnostic (ICD-9-CM, ICD-10-CM, CDC mortality, WHO), \code{0L} for procedural
(ICD-9-PCS, ICD-10-PCS). Defaults to both.}
}
\value{
A character vector the same length as \code{x}.
}
\description{
Take an assumed ICD compact code string and convert to a full code based on
the ICD version (9 or 10) and type (diagnostic or procedure).  This method
only formats strings and does not validate the code(s).
}
\seealso{
\itemize{
\item \code{\link[=get_icd_codes]{get_icd_codes()}} to retrieve the internal lookup table of ICD codes.
\item \code{\link[=lookup_icd_codes]{lookup_icd_codes()}} for retrieving details on a specific set of ICD
codes.
\item \code{\link[=is_icd]{is_icd()}} to test if a string is a known ICD code.
}

Other ICD tools: 
\code{\link{is_icd}()},
\code{\link{lookup_icd_codes}()}
}
\concept{ICD tools}
