% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{drop_share}
\alias{drop_share}
\title{Drop a MotherDuck share}
\usage{
drop_share(.con, share_name)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}

\item{share_name}{Character. The name of the share to be dropped.}
}
\value{
Invisibly returns \code{NULL}. Side effect: the specified share is removed if it exists.
}
\description{
Drops (deletes) a specified share from your MotherDuck account. If the share
does not exist, a warning is displayed. This function safely validates the
connection and share name before executing the operation.
}
\details{
The function first validates that the connection is active. It then checks
whether the specified share exists in the account. If it does, the share is
dropped using a \verb{DROP SHARE IF EXISTS} SQL command. If the share does not
exist, a warning is shown. After the operation, the current user is displayed.
}
\examples{
\dontrun{
drop_share(con_md, "test_share")
}

}
\seealso{
Other db-manage: 
\code{\link{alter_table_schema}()},
\code{\link{copy_tables_to_new_location}()},
\code{\link{create_database}()},
\code{\link{create_if_not_exists_share}()},
\code{\link{create_or_replace_share}()},
\code{\link{create_schema}()},
\code{\link{create_table}()},
\code{\link{delete_and_create_schema}()},
\code{\link{delete_database}()},
\code{\link{delete_schema}()},
\code{\link{delete_table}()},
\code{\link{describe_share}()},
\code{\link{list_owned_shares}()},
\code{\link{list_shared_with_me_shares}()},
\code{\link{upload_database_to_md}()}
}
\concept{db-manage}
