% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_solvers.R
\name{normalize_sgmwcs_instance}
\alias{normalize_sgmwcs_instance}
\title{Helper function to convert an \code{igraph} object into a proper SGMWCS instance}
\usage{
normalize_sgmwcs_instance(
  g,
  nodes.weight.column = "weight",
  edges.weight.column = "weight",
  nodes.group.by = "signal",
  edges.group.by = "signal",
  group.only.positive = TRUE
)
}
\arguments{
\item{g}{Graph to convert}

\item{nodes.weight.column}{Nodes column name (e.g. weight, score, w) for scoring}

\item{edges.weight.column}{Edges column name for scoring}

\item{nodes.group.by}{Nodes grouping column (e.g. signal, group, class)}

\item{edges.group.by}{Edges grouping column}

\item{group.only.positive}{Whether to group only positive-scored nodes/edges#'}
}
\value{
An \code{igraph} object with proper attributes set.
}
\description{
This function generates new \code{igraph} object with additional \code{signals} field added.
The way the instance is constructed is defined by the function parameters.
Nodes and edges are grouped separately, grouping columns are defined
by \code{nodes.group.by} and \code{edges.group.by} arguments. \code{group.only.positive} param specifies
whether to group only positive-weighted (specified by \code{nodes/edges.weight.column}) nodes and edges.
}
\examples{
data("gatom_example")
normalize_sgmwcs_instance(gatom_example)

}
