% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{aggregate_time}
\alias{aggregate_time}
\title{Aggregate Time Series}
\usage{
aggregate_time(
  data,
  period = c("year", "quarter", "month"),
  value_col = "OBS_VALUE",
  fun = mean
)
}
\arguments{
\item{data}{Data frame with DATE column}

\item{period}{Aggregation period: "year", "quarter", "month"}

\item{value_col}{Column containing values to aggregate}

\item{fun}{Aggregation function (default: mean)}
}
\value{
A tibble with PERIOD column and aggregated values.
}
\description{
Aggregates data over time periods.
}
\examples{
data(jsa_sample)
\donttest{
if ("DATE" \%in\% names(jsa_sample)) {
  yearly_data <- aggregate_time(jsa_sample, "year", "OBS_VALUE")
}
}
}
