% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_urban_park_animal_condition.R
\name{nyc_urban_park_animal_condition}
\alias{nyc_urban_park_animal_condition}
\title{NYC Urban Park Ranger Animal Condition Response}
\source{
NYC Open Data: <https://data.cityofnewyork.us/resource/fuhs-xmg2>
}
\usage{
nyc_urban_park_animal_condition(limit = 10000, filters = list())
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}
}
\value{
A tibble containing Urban Park Ranger Animal Condition Response data.
}
\description{
Downloads Urban Park Ranger Animal Condition Response data from NYC Open Data.
}
\details{
This dataset records responses by NYC Urban Park Rangers to animal-related
incidents across the five boroughs. It includes information on species,
condition, location, and outcome, helping to monitor urban wildlife trends
and public safety interactions.
}
\examples{
# Quick example (fetch 10 rows)
small_sample <- nyc_urban_park_animal_condition(limit = 10)
head(small_sample)

\donttest{
nyc_urban_park_animal_condition(limit = 5000)
nyc_urban_park_animal_condition(filters = list(age = "Infant"))
}

}
