% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_save}
\alias{wb_save}
\title{Save a workbook to file}
\usage{
wb_save(wb, file = NULL, overwrite = TRUE, path = NULL, flush = FALSE)
}
\arguments{
\item{wb}{A \code{wbWorkbook} object to write to file}

\item{file}{A path to save the workbook to}

\item{overwrite}{If \code{FALSE}, will not overwrite when \code{file} already exists.}

\item{path}{Deprecated argument. Please use \code{file} in new code.}

\item{flush}{Experimental, streams the worksheet file to disk}
}
\value{
the \code{wbWorkbook} object, invisibly
}
\description{
Save a workbook to file
}
\details{
When saving a \code{wbWorkbook} to a file, memory usage may spike
depending on the worksheet size. This happens because the entire XML
structure is created in memory before writing to disk. The memory
required depends on worksheet size, as XML files consist of character
data and include additional overhead for validity checks.

The \code{flush} argument streams worksheet XML data directly to disk,
avoiding the need to build the full XML tree in memory. This reduces
memory usage but skips some XML validity checks. It also bypasses
the \code{pugixml} functions that \code{openxlsx2} uses, omitting certain
preliminary sanity checks before writing. As the name suggests,
the output is simply flushed to disk.

By default, the \code{\link[utils:zip]{utils::zip()}} function is used to create output files.
This requires a working zip utility to be available on the system. A valid
zip program must be found either via \code{Sys.which("zip")} or through the
\code{R_ZIPCMD} environment variable.

On Windows, a suitable zip tool is typically provided by Rtools. If
\code{R_ZIPCMD} is not set, \code{openxlsx2} will automatically use the first detected
Rtools installation. If no zip utility is available, \code{bsdtar} can be used as
an alternative. On Windows this is shipped as \code{tar.exe}; on Mac and Linux
it is usually available as \code{bsdtar} (often requiring installation of the
\code{archive} package).

A further fallback—primarily for older Windows systems—is to point
\code{R_ZIPCMD} to \verb{7z.exe}. This approach has not been extensively tested and is
not reliable with 7-Zip on macOS.

As an additional fallback, the \code{zip} package can be used. It is no longer
listed in \code{Imports} and must be installed separately if needed.
}
\examples{
## Create a new workbook and add a worksheet
wb <- wb_workbook("Creator of workbook")
wb$add_worksheet(sheet = "My first worksheet")

## Save workbook to working directory
\donttest{
wb_save(wb, file = temp_xlsx(), overwrite = TRUE)

## do not use utils::zip, will try to use bsdtar
# options("openxlsx2.no_utils_zip" = TRUE)

## if the above is set as well, do not use bsdtar
# options("openxlsx2.no_bsdtar" = TRUE)

## use 7zip on Windows this works, on Mac not
# Sys.setenv("R_ZIPCMD" = "C:\\Program Files\\7-Zip\\7z.exe")

# if the last one is left blank the fallback is zip::zip
openxlsx2::write_xlsx(x = cars, temp_xlsx())
}
}
\seealso{
Other workbook wrappers: 
\code{\link{base_font-wb}},
\code{\link{col_widths-wb}},
\code{\link{creators-wb}},
\code{\link{grouping-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_hyperlink}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_slicer}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_base_colors}},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_copy_cells}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_workbook}()}
}
\concept{workbook wrappers}
