% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dist_one_many}
\alias{dist_one_many}
\title{Distances and Similarities between One and Many Probability Density Functions}
\usage{
dist_one_many(
  P,
  dists,
  method,
  p = NULL,
  testNA = TRUE,
  unit = "log",
  epsilon = 1e-05,
  num_threads = NULL
)
}
\arguments{
\item{P}{a numeric vector storing the first distribution.}

\item{dists}{a numeric matrix storing distributions in its rows.}

\item{method}{a character string indicating whether the distance measure that should be computed.}

\item{p}{power of the Minkowski distance.}

\item{testNA}{a logical value indicating whether or not distributions shall be checked for \code{NA} values.}

\item{unit}{type of \code{log} function. Option are
\itemize{
\item \code{unit = "log"}
\item \code{unit = "log2"}
\item \code{unit = "log10"}
}}

\item{epsilon}{epsilon a small value to address cases in the distance computation where division by zero occurs. In
these cases, x / 0 or 0 / 0 will be replaced by \code{epsilon}. The default is \code{epsilon = 0.00001}.
However, we recommend to choose a custom \code{epsilon} value depending on the size of the input vectors,
the expected similarity between compared probability density functions and
whether or not many 0 values are present within the compared vectors.
As a rough rule of thumb we suggest that when dealing with very large
input vectors which are very similar and contain many \code{0} values,
the \code{epsilon} value should be set even smaller (e.g. \code{epsilon = 0.000000001}),
whereas when vector sizes are small or distributions very divergent then
higher \code{epsilon} values may also be appropriate (e.g. \code{epsilon = 0.01}).
Addressing this \code{epsilon} issue is important to avoid cases where distance metrics
return negative values which are not defined and only occur due to the
technical issues of computing x / 0 or 0 / 0 cases.}

\item{num_threads}{an integer specifying the number of threads to be used for parallel computations. Default is taken from the `RCPP_PARALLEL_NUM_THREADS` environment variable, or `2` if not set.}
}
\value{
A vector of distance values
}
\description{
This functions computes the distance/dissimilarity between one probability density functions and a set of probability density functions.
}
\examples{
  set.seed(2020-08-20)
  P <- 1:10 / sum(1:10)
  M <- t(replicate(100, sample(1:10, size = 10) / 55))
  dist_one_many(P, M, method = "euclidean", testNA = FALSE)
}
