% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radarplot.R
\name{RadarPlotAtomic}
\alias{RadarPlotAtomic}
\title{Atomic Radar plot}
\usage{
RadarPlotAtomic(
  data,
  x,
  x_sep = "_",
  group_by = NULL,
  group_by_sep = "_",
  y = NULL,
  group_name = NULL,
  scale_y = c("group", "global", "x", "none"),
  y_min = 0,
  y_max = NULL,
  y_nbreaks = 4,
  polygon = FALSE,
  fill = TRUE,
  linewidth = 1,
  pt_size = 4,
  max_charwidth = 16,
  bg_color = "grey80",
  bg_alpha = 0.1,
  theme = "theme_this",
  theme_args = list(),
  palette = "Paired",
  palcolor = NULL,
  facet_by = NULL,
  facet_scales = "fixed",
  facet_ncol = NULL,
  facet_nrow = NULL,
  facet_byrow = TRUE,
  alpha = 0.2,
  aspect.ratio = 1,
  legend.position = waiver(),
  legend.direction = "vertical",
  title = NULL,
  subtitle = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{x}{A character string of the column name to plot on the x-axis/circles.
A character/factor column is expected.}

\item{x_sep}{A character string to concatenate the columns in \code{x}, if multiple columns are provided.}

\item{group_by}{A character string of the column name(s) to group the data (the lines) by.
Character/factor column(s) is expected.}

\item{group_by_sep}{A character string to concatenate the columns in \code{group_by}, if multiple columns are provided.}

\item{y}{A character string of the column name to plot on the y-axis.
A numeric column is expected.
If NULL, the count of the x-axis column in each group will be used.}

\item{group_name}{A character string to name the legend of group.}

\item{scale_y}{How should the y-axis be scaled? Default is "group".
Other options are "global", "x" and "none".
\itemize{
\item If "group", the y-axis will be scaled to the fraction within each group.
\item If "global", the y-axis will be scaled to the fraction of the total.
\item If "x", the y-axis will be scaled to the fraction of the total within each x-axis group.
\item If "none", the y-axis will be scaled to the count of each x-axis group.
}}

\item{y_min}{A numeric value to set the minimum value of the y-axis.}

\item{y_max}{A numeric value to set the maximum value of the y-axis.}

\item{y_nbreaks}{A numeric value to set the number of breaks in the y-axis.}

\item{polygon}{A logical value to draw the polygons instead of the circles as panel grid.}

\item{fill}{A logical value to fill the polygons with colors.}

\item{linewidth}{A numeric value to set the width of the lines.}

\item{pt_size}{A numeric value to set the size of the points.}

\item{max_charwidth}{A numeric value to set the maximum character width for the x labels.}

\item{bg_color}{A character string to set the background color of the plot.}

\item{bg_alpha}{A numeric value to set the transparency of the background color.}

\item{theme}{A character string or a theme class (i.e. ggplot2::theme_classic) specifying the theme to use.
Default is "theme_this".}

\item{theme_args}{A list of arguments to pass to the theme function.}

\item{palette}{A character string specifying the palette to use.
A named list or vector can be used to specify the palettes for different \code{split_by} values.}

\item{palcolor}{A character string specifying the color to use in the palette.
A named list can be used to specify the colors for different \code{split_by} values.
If some values are missing, the values from the palette will be used (palcolor will be NULL for those values).}

\item{facet_by}{A character string specifying the column name of the data frame to facet the plot.
Otherwise, the data will be split by \code{split_by} and generate multiple plots
and combine them into one using \code{patchwork::wrap_plots}}

\item{facet_scales}{Whether to scale the axes of facets. Default is "fixed"
Other options are "free", "free_x", "free_y". See \code{ggplot2::facet_wrap}}

\item{facet_ncol}{A numeric value specifying the number of columns in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_nrow}{A numeric value specifying the number of rows in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_byrow}{A logical value indicating whether to fill the plots by row. Default is TRUE.}

\item{alpha}{A numeric value specifying the transparency of the plot.}

\item{aspect.ratio}{A numeric value specifying the aspect ratio of the plot.}

\item{legend.position}{A character string specifying the position of the legend.
if \code{waiver()}, for single groups, the legend will be "none", otherwise "right".}

\item{legend.direction}{A character string specifying the direction of the legend.}

\item{title}{A character string specifying the title of the plot.
A function can be used to generate the title based on the default title.
This is useful when split_by is used and the title needs to be dynamic.}

\item{subtitle}{A character string specifying the subtitle of the plot.}

\item{...}{Additional arguments.}
}
\value{
A ggplot object
}
\description{
Atomic Radar plot
}
\keyword{internal}
