% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fns.R
\name{statres_histogram}
\alias{statres_histogram}
\title{Fold change histogram for statres objects}
\usage{
statres_histogram(
  x,
  fc_colors = c("blue", "darkgray"),
  text_size,
  x_lab,
  y_lab,
  title_lab,
  legend_lab,
  free_y_axis,
  show_sig
)
}
\arguments{
\item{x, fc_colors}{passed from
\code{\link[pmartR:plot.statRes]{pmartR::plot.statRes()}}}

\item{text_size}{An integer specifying the size of the text (number of
non-missing values) within the plot. The default is 3.
be displayed on the bar plot. The default is TRUE.}

\item{x_lab}{character string specifying the x-axis label.}

\item{y_lab}{character string specifying the y-axis label.}

\item{title_lab}{character string specifying the plot title.}

\item{legend_lab}{character string specifying the legend title.}

\item{free_y_axis}{logical specifying whether to use \code{scales = 'free'} in \code{ggplot2::facet_wrap}}

\item{show_sig}{logical specifying whether only significant fold changes
are included in the histogram or all fold changes}
}
\value{
`ggplot` object - histogram
}
\description{
Plots a histogram indicating the number of significant
biomolecules, grouped by test type and fold change direction.
}
\keyword{internal}
