% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{mean_if}
\alias{mean_if}
\title{Mean Conditional on Minimum Frequency of Observed Values}
\usage{
mean_if(x, trim = 0, ov.min = 1, prop = TRUE, inclusive = TRUE)
}
\arguments{
\item{x}{numeric or logical vector.}

\item{trim}{numeric vector of length 1 specifying the proportion of values
from each end of \code{x} to trim. Trimmed values are recoded to their
endpoint for calculation of the mean. See \code{mean.default}.}

\item{ov.min}{minimum frequency of observed values required. If \code{prop} =
TRUE, then this is a decimal between 0 and 1. If \code{prop} = FALSE, then
this is a integer between 0 and \code{length(x)}.}

\item{prop}{logical vector of length 1 specifying whether \code{ov.min}
should refer to the proportion of observed values (TRUE) or the count of
observed values (FALSE).}

\item{inclusive}{logical vector of length 1 specifying whether the mean
should be calculated if the frequency of observed values is exactly equal
to \code{ov.min}.}
}
\value{
numeric vector of length 1 providing the mean of \code{x} or
  \code{NA} conditional on if the frequency of observed data is greater than
  (or equal to) \code{ov.min}.
}
\description{
\code{mean_if} calculates the mean of a numeric or logical vector conditional
on a specified minimum frequency of observed values. If the frequency of
observed values is less than (or equal to) \code{ov.min}, then \code{NA} is
returned rather than the mean.
}
\examples{
mean_if(x = airquality[[1]], ov.min = .75) # proportion of observed values
mean_if(x = airquality[[1]], ov.min = 116,
   prop = FALSE) # count of observe values
mean_if(x = airquality[[1]], ov.min = 116, prop = FALSE,
   inclusive = FALSE) # not include ov.min value itself
mean_if(x = c(TRUE, NA, FALSE, NA),
   ov.min = .50) # works with logical vectors as well as numeric
}
\seealso{
\code{\link{mean.default}}
   \code{\link{sum_if}}
   \code{\link{make.fun_if}}
}
