% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partisan.R
\name{part_egap_ep}
\alias{part_egap_ep}
\title{Calculate Efficiency Gap (Equal Population Assumption)}
\usage{
part_egap_ep(plans, shp, dvote, rvote)
}
\arguments{
\item{plans}{A \code{redist_plans} object or plans_matrix where each row indicates a district assignment and each column is a plan.}

\item{shp}{A \code{redist_map} object, tibble, or data frame containing other columns.}

\item{dvote}{Unqouted name of column in \code{shp} with total population.}

\item{rvote}{Unqouted name of column in \code{shp} with group population.}
}
\value{
A numeric vector. Can be shaped into a district-by-plan matrix.
}
\description{
Calculate Efficiency Gap (Equal Population Assumption)
}
\examples{
data(nh)
data(nh_m)
# For a single plan:
part_egap_ep(plans = nh$r_2020, shp = nh, rvote = nrv, dvote = ndv)

# Or many plans:
part_egap_ep(plans = nh_m[, 3:5], shp = nh, rvote = nrv, dvote = ndv)

}
\references{
Nicholas O. Stephanopoulos. 2015.
Partisan Gerrymandering and the Efficiency Gap.
The University of Chicago Law Review, 82, Pp. 831-900.
}
\concept{partisan}
