% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fconditional_round.R
\name{f_conditional_round}
\alias{f_conditional_round}
\title{Conditional Rounding for Numeric Values}
\usage{
f_conditional_round(
  x,
  threshold_small = 0.01,
  threshold_large = 9999,
  digits = 3,
  replace_na = TRUE,
  detect_int_col = TRUE
)
}
\arguments{
\item{x}{A numeric vector or data frame containing numeric columns to be formatted.}

\item{threshold_small}{Numeric value. Values with absolute magnitude smaller than this
threshold will be formatted using scientific notation. Default is \code{0.01}.}

\item{threshold_large}{Numeric value. Values with absolute magnitude larger than or equal
to this threshold will be formatted using scientific notation. Default is \code{9999}.}

\item{digits}{Integer. Number of significant digits to use in formatting. Default is \code{3}.}

\item{replace_na}{Logical. If TRUE, NA values will be replaced with empty strings ("")
in the output. Default is TRUE.}

\item{detect_int_col}{Logical. If \code{TRUE}, columns in a data.frame containing only integers will be displayed without decimal digits. Columns containing a mix of integers and decimal values will display all values with the specified number of digits. If \code{FALSE}, each individual cell is evaluated: integer values are displayed without digits, and numbers containing digits with the specified number of digits. Default is \code{TRUE}.}
}
\value{
\itemize{
  \item If input is a vector: A character vector of the same length as the input, with values
formatted according to the specified rules.

  \item If input is a data frame: A data frame with the same structure as the input, but with
character columns formatted according to the specified rules.
 }
}
\description{
Conditionally formats numeric values based on their magnitude. Values that are very small
or very large are formatted using scientific notation, while other values are rounded
to a specified number of decimal places. Integers are preserved without decimal places.
When applied to a data frame, only numeric columns are processed. All output is character string.
}
\details{
The function applies the following formatting rules:
\itemize{
  \item Values smaller than \code{threshold_small} or larger than \code{threshold_large}
        are formatted in scientific notation with \code{digits} significant digits.
  \item Integer values are formatted without decimal places.
  \item Non-integer values that don't require scientific notation are rounded to
        \code{digits} decimal places.
  \item NA values are replaced with empty strings if \code{replace_na = TRUE}.
  \item Empty strings in the input are preserved.
  \item For data frames, only numeric columns are processed; other columns remain unchanged.
}
}
\examples{
# Vector examples.
f_conditional_round(c(0.0001, 0.5, 3, 10000))
# Returns: "1.000e-04" "0.500" "3" "1.000e+04".

f_conditional_round(c(0.0001, 0.5, 3, 10000, NA), replace_na = TRUE)
# Returns: "1.000e-04" "0.500" "3" "1.000e+04" ""

# Data frame example.
df <- data.frame(
  name = c("A", "B", "C"),
  small_val = c(0.0001, 0.002, 0.5),
  integer = c(1, 2, 3),
  integer_mix = c(10, 20, 30.1),
  large_val = c(10000, 5000, NA)
)

# Show only two digits.
f_conditional_round(df, digits = 2)

# To keep Integers as Integers (no digits)
# in columns with mixed data (Integers and digits)
# set detect_int_col = FALSE
f_conditional_round(df, detect_int_col = FALSE)

}
\author{
Sander H. van Delden  \email{plantmind@proton.me} \cr
}
