% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fglm.R
\name{f_glm}
\alias{f_glm}
\title{Perform multiple \code{glm()} functions with diagnostics, assumption checking, and post-hoc analysis}
\usage{
f_glm(
  formula,
  family = gaussian(),
  data = NULL,
  diagnostic_plots = TRUE,
  alpha = 0.05,
  adjust = "sidak",
  type = "response",
  intro_text = TRUE,
  dispersion_test = TRUE,
  output_type = "off",
  save_as = NULL,
  save_in_wdir = FALSE,
  close_generated_files = FALSE,
  open_generated_files = TRUE,
  influence_threshold = 2,
  ...
)
}
\arguments{
\item{formula}{A formula specifying the model to be fitted. More response variables can be
added using \code{-} or \code{+} (e.g., \code{response1 + response2 ~ predictor}) to do
a sequential GLM for each response parameter.}

\item{family}{The error distribution and link function to be used in the model (default: gaussian()).
This can be a character string naming a family function, a family function or
the result of a call to a family function. (See \code{\link{family}} for details of family functions.)}

\item{data}{A data frame containing the variables in the model.}

\item{diagnostic_plots}{Logical. If \code{TRUE}, plots are included in the output files.}

\item{alpha}{Numeric. Significance level for tests. Default is \code{0.05}.}

\item{adjust}{Character string specifying the method used to adjust p-values
for multiple comparisons. Available methods include:
\describe{
  \item{"tukey"}{Tukey's Honest Significant Difference method}
  \item{"sidak"}{Šidák correction}
  \item{"bonferroni"}{Bonferroni correction}
  \item{"none"}{No adjustment}
  \item{"fdr"}{False Discovery Rate adjustment}
} Default is \code{"sidak"}.}

\item{type}{specifying the scale on which the emmeans posthoc results are presented, e.g. "link" to show results on the scale for which the variables are linear and "response" when you want to back transform the data to interpret results in the units of your original data (e.g., probabilities, counts, or untransformed measurements). Default is \code{"response"}.}

\item{intro_text}{Logical. If \code{TRUE}, includes a short explanation about GLM assumptions in the output file.}

\item{dispersion_test}{Logical for overdispersion test (default: TRUE).}

\item{output_type}{Character string specifying the output format: \code{"pdf"}, \code{"word"}, \code{"excel"}, \code{"rmd"}, \code{"console"} or \code{"off"} (no file generated). The option \code{"console"} forces output to be printed, the option \code{"rmd"} saves rmd code in the output object not in a file. Default is \code{"off"}.}

\item{save_as}{Character string specifying the output file path (without extension).
If a full path is provided, output is saved to that location.
If only a filename is given, the file is saved in \code{tempdir()}.
If only a directory is specified (providing an existing directory with trailing slash),
the file is named "dataname_glm_output" in that directory. If an extension is provided the output format specified with option "output_type" will be overruled.
Defaults to \code{file.path(tempdir(), "dataname_summary.pdf")}.}

\item{save_in_wdir}{Logical. If \code{TRUE}, saves the file in the working directory.}

\item{close_generated_files}{Logical. If \code{TRUE}, closes open 'Excel' or 'Word' files depending on the output format. This to be able to save the newly generated file by the \code{f_aov()} function. 'Pdf' files should also be closed before using the function and cannot be automatically closed. Default is \code{FALSE}.}

\item{open_generated_files}{Logical. If \code{TRUE}, Opens the generated output files ('pdf', 'Word' or 'Excel') files depending on the output format. This to directly view the results after creation. Files are stored in tempdir(). Default is \code{TRUE}.}

\item{influence_threshold}{Leverage threshold (default: 2).}

\item{...}{Additional arguments passed to \code{glm()}.}
}
\value{
An object of class 'f_glm' containing results from \code{glm()}, diagnostics, and post-hoc tests. Using the option "output_type", it can also generate output in the form of: R Markdown code, 'Word', 'pdf', or 'Excel' files. Includes print and plot methods for 'f_glm' objects.
}
\description{
Performs Generalized Linear Model (GLM) analysis on a given dataset with options for
diagnostics, assumption checking, and post-hoc analysis. Several response parameters
can be analyzed in sequence and the generated output can be in various formats
('Word', 'pdf', 'Excel').
}
\details{
The function first checks if all specified variables are present in the data and ensures that the response variable is numeric.

It performs Analysis of Variance (ANOVA) using the specified formula and data. If \code{shapiro = TRUE}, it checks for normality of residuals using the Shapiro-Wilk test and optionally (\code{transformation = TRUE}) applies a data transformation if residuals are not normal.

If significant differences are found in ANOVA, it proceeds with post hoc tests using estimated marginal means from \code{emmeans()} and Sidak adjustment (or another option of \code{adjust =}.

More response variables can be added using \code{-} or \code{+} (e.g., \code{response1 + response2 ~ predictor}) to do a sequential \code{aov()} for each response parameter captured in one output file.

Outputs can be generated in multiple formats ("pdf", "word", "excel" and "rmd") as specified by \code{output_type}. The function also closes any open 'Word' files to avoid conflicts when generating 'Word' documents. If \code{output_type = "rmd"} is used it is adviced to use it in a chunk with \{r, echo=FALSE, results='asis'\}

This function requires [Pandoc](https://github.com/jgm/pandoc/releases/tag) (version 1.12.3 or higher), a universal document converter.
\itemize{
\item \bold{Windows:} Install Pandoc and ensure the installation folder \cr (e.g., "C:/Users/your_username/AppData/Local/Pandoc") is added to your system PATH.
\item \bold{macOS:} If using Homebrew, Pandoc is typically installed in "/usr/local/bin". Alternatively, download the .pkg installer and verify that the binary’s location is in your PATH.
\item \bold{Linux:} Install Pandoc through your distribution’s package manager (commonly installed in "/usr/bin" or "/usr/local/bin") or manually, and ensure the directory containing Pandoc is in your PATH.

\item If Pandoc is not found, this function may not work as intended.
}
}
\examples{
# GLM Binomial example with output to console and MS Word file
mtcars_mod <- mtcars
mtcars_mod$cyl <- as.factor(mtcars_mod$cyl)

glm_bin <- f_glm(vs ~ cyl,
                 family = binomial,
                 data = mtcars_mod,
                 output_type = "word",
                 # Do not automatically open the 'Word' file (Default is to open the file)
                 open_generated_files = FALSE)
print(glm_bin)

\donttest{
# GLM Poisson example with output to rmd text
data(warpbreaks)

glm_pos <- f_glm(breaks ~ wool + tension,
                 data = warpbreaks,
                 family = poisson(link = "log"),
                 intro_text = FALSE,
                 output_type = "rmd")
cat(cat(glm_pos$rmd))
}

}
\author{
Sander H. van Delden  \email{plantmind@proton.me} \cr
}
