% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress_utils.R
\name{create_progressor}
\alias{create_progressor}
\title{Create a Progress Reporter for Iterative Operations}
\usage{
create_progressor(steps, enable = TRUE)
}
\arguments{
\item{steps}{Integer specifying the total number of steps}

\item{enable}{Logical indicating whether to enable progress reporting (default: TRUE)}
}
\value{
A function that signals progress when called. If progressr is not available
or \code{enable = FALSE}, returns a no-op function.
}
\description{
Creates a progress reporting function for use in loops or apply-style operations.
Returns a no-op function if progressr is not available or disabled.
}
\details{
This function wraps \code{progressr::progressor()} with a fallback for when progressr
is not available.
}
\examples{
\dontrun{
# Enable progress reporting
progressr::handlers("progress")

# Use in a loop
p <- create_progressor(10)
results <- lapply(1:10, function(i) {
  Sys.sleep(0.1)
  p()  # Signal progress
  i^2
})
}

}
\seealso{
\code{\link[progressr:progressor]{progressr::progressor()}}, \code{\link[=with_progress]{with_progress()}}
}
\keyword{internal}
