% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_metrics.R
\name{check_forbidden_notes}
\alias{check_forbidden_notes}
\title{Reclassify Forbidden Notes as Errors in rcmdcheck Results}
\usage{
check_forbidden_notes(res_check, pkg_name)
}
\arguments{
\item{res_check}{A list representing the result of an `rcmdcheck` run. It should contain
at least the elements `notes`, `warnings`, and `errors`, each being a character vector.}

\item{pkg_name}{name of the package}
}
\value{
A modified version of `res_check` where certain notes matching forbidden patterns
  are moved to the `errors` field.
}
\description{
This internal helper function scans the `notes` field of an `rcmdcheck` result object
for specific patterns that indicate more serious issues. If any of these patterns are found,
the corresponding notes are reclassified as errors by moving them from the `notes` field
to the `errors` field.
}
\examples{
\donttest{
pkg_name <- "foo"
res_check <- list(
  notes = c("'foo' import not declared from: 'bar'",
            "Namespace in Imports field not imported from: 'baz'",
            "no visible global function definition for 'qux'",
            "some harmless note"),
  warnings = character(0),
  errors = character(0)
)
updated <- check_forbidden_notes(res_check, pkg_name)
print(updated$errors)  # Should include the first three notes
print(updated$notes)   # Should include only the harmless note
}
}
