% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_prob.R
\docType{data}
\name{err}
\alias{err}
\title{Error rate (err) as the probability of an incorrect decision.}
\format{
An object of class \code{numeric} of length 1.
}
\usage{
err
}
\description{
\code{err} defines the error rate as the complement of
accuracy \code{\link{acc}} or lack of correspondence
of decisions to conditions.
}
\details{
Definition:

\code{err = (1 - \link{acc})}

When \code{\link{freq}} are not rounded (\code{round = FALSE}) then

\code{err = \link{dec_err}/\link{N} = (\link{mi} + \link{fa})/\link{N}}

\code{err} is currently not included in \code{\link{prob}},
but shown in plots.

See \code{err}'s complement of accuracy \code{\link{acc}}
for computation and
\code{\link{accu}} for current accuracy metrics
and several possible interpretations of accuracy.
}
\examples{
err <- .50     # sets a rate of incorrect decisions of 50\%
err <- 50/100  # (dec_err) for 50 out of 100 individuals
is_prob(err)   # TRUE

}
\seealso{
\code{\link{acc}} provides overall accuracy;
\code{\link{comp_acc}} computes accuracy from probabilities;
\code{\link{accu}} lists current accuracy metrics;
\code{\link{comp_accu_prob}} computes exact accuracy metrics from probabilities;
\code{\link{comp_accu_freq}} computes accuracy metrics from frequencies;
\code{\link{comp_sens}} and \code{\link{comp_PPV}} compute related probabilities;
\code{\link{is_extreme_prob_set}} verifies extreme cases;
\code{\link{comp_complement}} computes a probability's complement;
\code{\link{is_complement}} verifies probability complements;
\code{\link{comp_prob}} computes current probability information;
\code{\link{prob}} contains current probability information;
\code{\link{is_prob}} verifies probabilities.

Other probabilities: 
\code{\link{FDR}},
\code{\link{FOR}},
\code{\link{NPV}},
\code{\link{PPV}},
\code{\link{acc}},
\code{\link{fart}},
\code{\link{mirt}},
\code{\link{ppod}},
\code{\link{prev}},
\code{\link{sens}},
\code{\link{spec}}

Other metrics: 
\code{\link{acc}},
\code{\link{accu}},
\code{\link{comp_acc}()},
\code{\link{comp_accu_freq}()},
\code{\link{comp_accu_prob}()},
\code{\link{comp_err}()}
}
\concept{metrics}
\concept{probabilities}
\keyword{datasets}
