% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define-SOM.R
\docType{class}
\name{Historical-class}
\alias{Historical-class}
\title{Class \code{"Historical"}}
\description{
Optional component of the operating model that specifies the historical dynamics.
}
\details{
Several approaches are possible:
\itemize{
\item No set up. Default option sets 1000 natural-origin juveniles (age 1), and 1000 hatchery-origin juveniles (age 1) if there is hatchery production (otherwise, zero).
\item \emph{Recommended option}: specify the initial spawning abundance in the terminal age class.
\item Detailed setup that reconstructs a historical population by specifying the juvenile abundance (at the beginning of the year),
annual fishing mortality rates, and spawner abundance. Typically used if there an estimation/conditioning model is used to inform
parameters of the operating model.
}
}
\section{Slots}{

\describe{
\item{\code{Name}}{Character. Identifying name}

\item{\code{HistSpawner_NOS}}{Natural origin spawners at age. Either a numeric to specify the total natural spawners (in the oldest age class)
at the beginning of the projection, otherwise, an array by \verb{[nsim, maxage, nyears, n_g]}. Default is 1,000 spawners.}

\item{\code{HistSpawner_HOS}}{Hatchery origin spawners at age. Either a numeric to specify the total hatchery spawners (in the oldest age class)
at the beginning of the projection, otherwise, an array by \verb{[nsim, maxage, nyears, n_r]}.
Default is 1,000 spawners if there is hatchery production or zero otherwise.}

\item{\code{HistNjuv_NOS}}{Array by \verb{[nsim, maxage, nyears+1, n_g]}. The abundance of immature natural origin fish at the beginning of the annual time step.
Default assumes 1000 smolts (age-1) fish annually.}

\item{\code{HistNjuv_HOS}}{Array by \verb{[nsim, maxage, nyears+1, n_r]}. The abundance of immature hatchery origin fish at the beginning of the annual time step.
Default assumes 1000 smolts (age-1) fish annually.}

\item{\code{HistFPT}}{Vector by historical years (\code{nyears}) or an array by dimension \verb{[nsim, nyears, 2]}. The instantaneous fishing mortality in the preterminal fishery.
The first array slice corresponds to F for natural origin fish and the second array slice corresponds to hatchery origin fish. Default is zero.}

\item{\code{HistFT}}{Vector by historical years (\code{nyears}) or an array by dimension \verb{[nsim, nyears, 2]}. The instantaneous fishing mortality in the terminal fishery.
The first array slice corresponds to F for natural origin fish and the second array slice corresponds to hatchery origin fish. Default is zero.}
}}

\section{Creating Object}{

Objects can be created by calls of the form \code{new("Historical")}
}

\examples{
showClass("Historical")
}
\keyword{classes}
