% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivityIxJ.R
\name{norm.score.sen.IxJ}
\alias{norm.score.sen.IxJ}
\title{Normal Approximation Sensitivity Analysis for I by J Tables}
\usage{
norm.score.sen.IxJ(
  obs.table,
  gamma,
  delta,
  row = "treatment",
  treatment.scores,
  outcome.scores,
  shared_divisor = 1e+06,
  u_space = NULL,
  verbose = FALSE
)
}
\arguments{
\item{obs.table}{A matrix or table object representing the observed contingency table.}

\item{gamma}{a nonnegative scalar.}

\item{delta}{a binary vector
to treatment levels. Its length must match the number of treatments
(rows of \code{obs.table} if \code{row = "treatment"}, or columns if
\code{row = "outcome"}).}

\item{row}{A string indicating whether rows represent "outcome" or "treatment". Must be
either "outcome" or "treatment". Default is "treatment".}

\item{treatment.scores}{A numeric vector of scores for treatments. Must be monotone
(either increasing or decreasing). Higher scores typically indicate more
intense treatments. Length must equal the number of treatments.}

\item{outcome.scores}{A numeric vector of scores for outcomes. Must be monotone
(either increasing or decreasing). Higher scores typically indicate better
outcomes. Length must equal the number of outcomes.}

\item{shared_divisor}{Numeric value used for numerical stability in calculations.
Default is 1e6.}

\item{u_space}{A numeric matrix where each row is a candidate \code{u_allocation}.
If \code{NULL} (default), corner allocations are generated automatically
for tables with J <= 5 outcomes.}

\item{verbose}{Logical; if \code{TRUE}, prints progress messages including
the current u-allocation and p-value at each step. Default is FALSE.}
}
\value{
A list containing:
\describe{
\item{T_obs}{The observed test statistic value.}
\item{RCT.mean}{Mean of the test statistic under RCT (gamma = 0) or (Gamma = 1).}
\item{max.mean}{Mean of the test statistic under the sensitivity model at maximizer.}
\item{RCT.var}{Variance of the test statistic under RCT.}
\item{max.var}{Variance of the test statistic under the sensitivity model at maximizer.}
\item{RCT.prob}{P-value under RCT (no unmeasured confounding).}
\item{max.prob}{Maximum p-value across all u-allocations (sensitivity bound).}
\item{maximizer}{The u-allocation vector that yields max.prob.}
\item{treatment.scores}{The treatment scores used in the analysis.}
\item{outcome.scores}{The outcome scores used in the analysis.}
}
}
\description{
This function implements normal approximation methods for sensitivity analysis
in I by J contingency tables under the generic bias model. It computes asymptotically
valid p-values for score test statistics based on the product of treatment and
outcome scores, providing rapid analysis for large tables.
}
\details{
For an I by J table, the test statistic is a weighted
sum of cell counts where weights are products of treatment and outcome scores:
\eqn{T = \sum w_i v_j N_{ij}} across all cells.

The method computes:
\itemize{
\item Mean and variance of the test statistic under the generic bias model
\item Standardized z-scores assuming asymptotic normality
\item the one-sided upper tailed probability
}

When \code{u_space} is not provided, the function automatically generates
corner u allocations which often
contain the worst-case scenarios for sensitivity analysis.
}
\examples{
# 2 by 3 table example with ordinal scores
obs.table <- matrix(c(10, 20, 30, 15, 25, 10), nrow = 2, byrow = TRUE)
treatment.scores <- c(0, 1)    # Control vs Treatment
outcome.scores <- c(0, 1, 2)   # Ordinal outcomes

result <- norm.score.sen.IxJ(obs.table = obs.table,
                      gamma = 0.5,
                      delta = c(0, 1),
                      treatment.scores = treatment.scores,
                      outcome.scores = outcome.scores
                      )

# 3 by 3 table with customized scores
obs.table <- matrix(data=c(10,30,10,14,15,24,4,5,15), nrow = 3)
treatment.scores <- c(0, 0.5, 1)  # Three treatment levels
outcome.scores <- c(0, 1, 2)   # three outcome levels

result <- norm.score.sen.IxJ(obs.table = obs.table,
                      gamma = 0.5,
                      delta = c(0, 0, 1),
                      treatment.scores = treatment.scores,
                      outcome.scores = outcome.scores
                      )

}
\seealso{
\code{\link{exact.general.sen.IxJ}} for exact methods,
\code{\link{sampling.general.sen.IxJ}} for Monte Carlo methods
}
