% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqHMM-package.R
\docType{package}
\name{seqHMM-package}
\alias{seqHMM-package}
\alias{seqHMM}
\title{The seqHMM package}
\description{
The seqHMM package is designed for fitting hidden (or latent) Markov models (HMMs) and
mixture hidden Markov models (MHMMs) for social sequence data and other categorical
time series. The package supports models for one or multiple subjects with one or
multiple interdependent sequences (channels). External covariates can be added to
explain cluster membership in mixture models. The package provides functions for evaluating
and comparing models, as well as functions for easy plotting of multichannel sequences
and hidden Markov models. Common restricted versions of (M)HMMs are also supported,
namely Markov models, mixture Markov models, and latent class models.
}
\details{
Maximum likelihood estimation via the EM algorithm and direct numerical maximization
with analytical gradients is supported. All main algorithms are written in C++.
Parallel computation is implemented via OpenMP for pre-2.0.0 functions, while
estimation of non-homogenous models support parallelization via \code{future}
package by parallelization of multistart optimizations and bootstrap sampling.
}
\references{
Helske S. and Helske J. (2019). Mixture Hidden Markov Models for Sequence Data: The seqHMM Package in R,
Journal of Statistical Software, 88(3), 1-32. doi:10.18637/jss.v088.i03
}
\seealso{
Useful links:
\itemize{
  \item Report bugs at \url{https://github.com/helske/seqHMM/issues}
}

}
\author{
\strong{Maintainer}: Jouni Helske \email{jouni.helske@iki.fi} (\href{https://orcid.org/0000-0001-7130-793X}{ORCID})

Authors:
\itemize{
  \item Satu Helske (\href{https://orcid.org/0000-0003-0532-0153}{ORCID})
}

}
