% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simulate_misaligned_data}
\alias{simulate_misaligned_data}
\title{Simulate Misaligned Spatial Data}
\usage{
simulate_misaligned_data(
  seed = 2,
  dist_covariates_x = c("normal", "poisson", "binomial"),
  dist_covariates_y = c("normal", "poisson", "binomial"),
  dist_y = "poisson",
  x_intercepts = rep(0, 3),
  y_intercepts = rep(0, 3),
  rho_x = 0.6,
  rho_y = 0.6,
  x_correlation = 0.5,
  y_correlation = 0.5,
  beta0_y = NULL,
  beta_x = NULL,
  beta_y = NULL,
  diff_pops = TRUE,
  xy_cov_cor = FALSE
)
}
\arguments{
\item{seed}{Random seed (default = 2)}

\item{dist_covariates_x}{Vector specifying distribution type for each synthetic X-grid covariate ('poisson', 'binomial', or 'normal')}

\item{dist_covariates_y}{Vector specifying distribution type for each synthetic Y-grid covariate ('poisson', 'binomial', or 'normal')}

\item{dist_y}{Distribution type for synthetic outcome variable (one of 'poisson', 'binomial', or 'normal')}

\item{x_intercepts}{Intercepts for X covariates}

\item{y_intercepts}{Intercepts for Y covariates}

\item{rho_x}{Spatial correlation parameter for X-grid covariates (0 to 1 with higher values yielding more spatial correlation, default = 0.6)}

\item{rho_y}{Spatial correlation parameter for Y-grid covariates and outcome (0 to 1 with higher values yielding more spatial correlation, default = 0.6)}

\item{x_correlation}{Between-variable correlation for all pairs of X-grid covariates (default = 0.5)}

\item{y_correlation}{Between-variable correlation for all pairs of Y-grid covariates (default = 0.5)}

\item{beta0_y}{Intercept for outcome model}

\item{beta_x}{Outcome model coefficients for X-grid covariates}

\item{beta_y}{Outcome model coefficients for Y-grid covariates}

\item{diff_pops}{Logical, indicating whether the atoms should be generated with different population sizes (diff_pops = TRUE) or a common population size (diff_pops = FALSE)}

\item{xy_cov_cor}{Logical, indicating whether the atom-level spatial random effects for X-grid and Y-grid covariates should be correlated (xy_cov_cor = TRUE) or not. When set to TRUE, the x_correlation and rho_x parameters are used to generate all covariates (separate correlation parameters are not allowed for X-grid and Y-grid covariates).}
}
\value{
List containing gridy, gridx, atoms, and true_params
}
\description{
Simulate Misaligned Spatial Data
}
