% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factories.R
\name{make_update}
\alias{make_update}
\title{Create an SQL UPDATE query.}
\usage{
make_update(tabl, set, where = NULL)
}
\arguments{
\item{tabl}{A table name.}

\item{set}{A StmtSet instance containing the fields to update.}

\item{where}{A StmtWhere instance to add a where clause (optional).}
}
\value{
An instance of QueryUpdate.
}
\description{
Create a QueryUpdate instance.
}
\examples{
# Generate a simple update query:
where <- StmtWhere$new(ExprBinOp$new(
  ExprField$new("year"), "<",
  ExprValue$new(2010)
))
set <- make_set(price = 9.50, old = TRUE)
update <- make_update('books', set = set, where = where)$toString()

}
