% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-dists.R
\name{ssd_fit_dists}
\alias{ssd_fit_dists}
\title{Fit Distributions}
\usage{
ssd_fit_dists(
  data,
  left = "Conc",
  ...,
  right = left,
  weight = NULL,
  dists = ssd_dists_bcanz(),
  nrow = 6L,
  rescale = FALSE,
  odds_max = 0.999,
  reweight = FALSE,
  computable = FALSE,
  at_boundary_ok = TRUE,
  all_dists = FALSE,
  min_pmix = ssd_min_pmix(nrow(data)),
  range_shape1 = c(0.05, 20),
  range_shape2 = range_shape1,
  control = list(),
  silent = FALSE
)
}
\arguments{
\item{data}{A data frame.}

\item{left}{A string of the column in data with the concentrations.}

\item{...}{Unused.}

\item{right}{A string of the column in data with the right concentration values.}

\item{weight}{A string of the numeric column in data with positive weights less than or equal to 1,000 or NULL.}

\item{dists}{A character vector of the distribution names.}

\item{nrow}{A positive whole number of the minimum number of non-missing rows.}

\item{rescale}{A flag specifying whether to leave the values unchanged (FALSE) or to rescale concentration values by dividing by the geometric mean of the minimum and maximum positive finite values (TRUE) or a string specifying whether to leave the values unchanged ("no") or to rescale concentration values by dividing by the geometric mean of the minimum and maximum positive finite values ("geomean") or to logistically transform ("odds").}

\item{odds_max}{A number specifying the upper left value when \code{rescale = "odds"}.
By default left values cannot exceed 0.999.}

\item{reweight}{A flag specifying whether to reweight weights by dividing by the largest weight.}

\item{computable}{A flag specifying whether to only return fits with numerically computable standard errors.}

\item{at_boundary_ok}{A flag specifying whether a model with one or more
parameters at the boundary should be considered to have converged (default = TRUE).}

\item{all_dists}{A flag specifying whether all the named distributions must fit successfully.}

\item{min_pmix}{A number between 0 and 0.5 specifying the minimum proportion in mixture models.}

\item{range_shape1}{A numeric vector of length two of the lower and upper bounds for the shape1 parameter.}

\item{range_shape2}{shape2 parameter.}

\item{control}{A list of control parameters passed to \code{\link[stats:optim]{stats::optim()}}.}

\item{silent}{A flag indicating whether fits should fail silently.}
}
\value{
An object of class fitdists.
}
\description{
Fits one or more distributions to species sensitivity data.
}
\details{
By default the 'gamma', 'lgumbel', 'llogis', 'lnorm', 'lnorm_lnorm' and
'weibull' distributions are fitted to the data.
For a complete list of the distributions that are currently implemented in
\code{ssdtools} see \code{\link[=ssd_dists_all]{ssd_dists_all()}}.

If weight specifies a column in the data frame with positive numbers,
weighted estimation occurs.
However, currently only the resultant parameter estimates are available.

If the \code{right} argument is different to the \code{left} argument
then the data are considered to be censored.
}
\examples{
fits <- ssd_fit_dists(ssddata::ccme_boron)
fits
ssd_plot_cdf(fits)
ssd_hc(fits)
}
\seealso{
\code{\link[=ssd_plot_cdf]{ssd_plot_cdf()}} and \code{\link[=ssd_hc]{ssd_hc()}}
}
