% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gxeMegaEnv.R
\name{gxeMegaEnv}
\alias{gxeMegaEnv}
\title{Form mega environments based on fitted values from an AMMI model}
\usage{
gxeMegaEnv(
  TD,
  trials = names(TD),
  trait,
  method = c("max", "min"),
  byYear = FALSE
)
}
\arguments{
\item{TD}{An object of class \code{\link[statgenSTA]{TD}}.}

\item{trials}{A character string specifying the trials to be analyzed. If
not supplied, all trials are used in the analysis.}

\item{trait}{A character string specifying the trait to be analyzed.}

\item{method}{A character string indicating the criterion to determine
the best genotype per environment, either \code{"max"} or \code{"min"}.}

\item{byYear}{Should the analysis be done by year? If \code{TRUE} the data
is split by the variable year, analysis is performed and the results are
merged together and returned.}
}
\value{
An object of class megaEnv, a list consisting of
\describe{
\item{TD}{An object of class TD, the TD object used as input to the function
with an extra column megaEnv.}
\item{summTab}{A data.frame, a summary table containing information on the
trials in each mega environment.}
\item{trait}{The trait used for calculating the mega environments.}
}
}
\description{
This function fits an AMMI model and then using the fitted values produces
a new factor clustering the trials. This factor is added as a column megaEnv
to the input data. If a column megaEnv already exists this column is
overwritten with a warning.\cr\cr
Mega environments are created by grouping environments based on their best
performing genotype; i.e. environments that share the same best genotype
belong to the same mega environment.
}
\examples{
## Calculate mega environments for TDMaize.
gemegaEnv <- gxeMegaEnv(TD = TDMaize, trait = "yld")

## Calculate new mega environments based on the genotypes with the lowest
## value per environment.
gemegaEnv2 <- gxeMegaEnv(TD = TDMaize, trait = "yld", method = "min")

}
\references{
Atlin, G. N., R. J. Baker, K. B. McRae, and X. Lu. 2000.
Selection Response in Subdivided Target Regions. Crop Sci. 40:7-13.
\doi{10.2135/cropsci2000.4017}
}
\seealso{
Other mega environments: 
\code{\link{plot.megaEnv}()},
\code{\link{predict.megaEnv}()}
}
\concept{mega environments}
