% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_inputs.R
\name{check_local_index_inputs}
\alias{check_local_index_inputs}
\title{Check inputs to local_max_index() and local_min_index()}
\usage{
check_local_index_inputs(dates, values, look_behind, look_ahead, look_units)
}
\arguments{
\item{dates}{A vector of dates of 'Date' class. There are 2 restrictions:
\itemize{
\item The vector must be in ascending order; duplicates are allowed
\item The vector cannot have missing values (i.e., no NA)
}}

\item{values}{A vector of numeric values. The values must be in correspondence with \code{dates},
meaning the \emph{i}th element in \code{values} must correspond to the \emph{i}th date in \code{dates}.}

\item{look_behind, look_ahead}{The number of \code{look_units} before and after the center date to
include in the sliding window to determine local maxima or minima.}

\item{look_units}{One of "days", "weeks", or "months". The units to give \code{look_ahead} and
\code{look_behind}.}
}
\value{
A TRUE/FALSE value with a "msg" attribute
}
\description{
Check inputs to local_max_index() and local_min_index()
}
\keyword{internal}
