% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolation.R
\name{stress2grid}
\alias{stress2grid}
\alias{stress2grid_stats}
\title{Spatial Interpolation of SHmax}
\usage{
stress2grid(
  x,
  stat = c("mean", "median", "tensor"),
  grid = NULL,
  lon_range = NULL,
  lat_range = NULL,
  gridsize = 2,
  min_data = 3L,
  max_data = Inf,
  max_sd = Inf,
  threshold = deprecated(),
  min_dist_threshold = 200,
  arte_thres = deprecated(),
  method_weighting = FALSE,
  quality_weighting = TRUE,
  dist_weighting = c("inverse", "linear", "none"),
  idp = 1,
  qp = 1,
  mp = 1,
  dist_threshold = 0.1,
  R_range = seq(50, 1000, 50),
  ...
)

stress2grid_stats(
  x,
  grid = NULL,
  lon_range = NULL,
  lat_range = NULL,
  gridsize = 2,
  min_data = 4L,
  max_data = Inf,
  threshold = deprecated(),
  min_dist_threshold = 200,
  arte_thres = deprecated(),
  method_weighting = FALSE,
  quality_weighting = TRUE,
  dist_weighting = c("inverse", "linear", "none"),
  idp = 1,
  qp = 1,
  mp = 1,
  dist_threshold = 0.1,
  R_range = seq(50, 1000, 50),
  mode = FALSE,
  kappa = 10,
  ...
)
}
\arguments{
\item{x}{\code{sf} object containing
\describe{
\item{azi}{SHmax in degree}
\item{unc}{(optional) Uncertainties of SHmax in degree}
\item{type}{(optional) Methods used for the determination of the direction
of SHmax}
}}

\item{stat}{whether the direction of interpolated SHmax is based on the
circular mean and standard deviation (\code{"mean"}, the default), the
quasi-circular median and quasi-interquartile range (\code{"median"}), or the
orientation tensor based principal direction and dispersion ("tensor").}

\item{grid}{(optional) Point object of class \code{sf}.}

\item{lon_range, lat_range}{(optional) numeric vector specifying the minimum
and maximum longitudes and latitudes (ignored if \code{grid} is specified).}

\item{gridsize}{numeric. Target spacing of the regular grid in decimal
degree. Default is \code{2.5}. (is ignored if \code{grid} is specified)}

\item{min_data}{integer. If the number of observations within distance
\code{R_range} is less than \code{min_data}, a missing value \code{NA} will be generated.
Default is \code{3} for \code{\link[=stress2grid]{stress2grid()}} and \code{4} for \code{\link[=stress2grid_stats]{stress2grid_stats()}}.}

\item{max_data}{integer. The number of nearest observations that should be
used for prediction, where "nearest" is defined in terms of the space of the
spatial locations. Default is \code{Inf}.}

\item{max_sd}{numeric. Threshold for deviation of direction in degrees;
if exceeds, missing values will be generated.}

\item{threshold}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} is no
longer supported; use \code{max_sd} instead.}

\item{min_dist_threshold}{numeric. Distance threshold for smallest distance
of the prediction location to the next observation location.
Default is \code{200} km.}

\item{arte_thres}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} is no
longer supported; use \code{min_dist_threshold} instead.}

\item{method_weighting}{logical. If a method weighting should be applied:
Default is \code{FALSE}. If \code{FALSE}, overwrites \code{mp}.}

\item{quality_weighting}{logical. If a quality weighting should be applied:
Default is \code{TRUE}. If \code{FALSE}, overwrites \code{qp}.}

\item{dist_weighting}{Distance weighting method which should be used. One of
\code{"none"}, \code{"linear"}, or \code{"inverse"} (the default).}

\item{idp, qp, mp}{numeric. The weighting power of inverse distance, quality
and method (the higher the value, the more weight).
Default is \code{1}. When set to \code{0}, no weighting is applied. Only effective when
\code{dist_weighting=="inverse"}.}

\item{dist_threshold}{numeric. Distance weight to prevent overweight of data
nearby (0 to 1). Default is \code{0.1}}

\item{R_range}{numeric value or vector specifying the kernel half-width(s)
search radii,
i.e. the maximum distance from the prediction location to be used for
prediction (in km). Default is \code{seq(50, 1000, 50)}. If combined with
\code{max_data}, both criteria apply.}

\item{...}{(optional) arguments to \code{\link[=dist_greatcircle]{dist_greatcircle()}}}

\item{mode}{logical. Should the circular mode be included in the statistical summary (slow)?}

\item{kappa}{numeric. von Mises distribution concentration parameter used
for the circular mode. Will be estimated using \code{\link[=est.kappa]{est.kappa()}} if not provided.}
}
\value{
\code{sf} object containing
\describe{
\item{lon,lat}{longitude and latitude in degrees}
\item{azi}{Circular mean od median SHmax in degree}
\item{sd}{Circular standard deviation or Quasi-IQR on the Circle of SHmax in degrees}
\item{R}{Search radius in km}
\item{mdr}{Mean distance between grid point and datapoints per search radius}
\item{N}{Number of data points in search radius}
}
When \code{\link[=stress2grid_stats]{stress2grid_stats()}}, \code{azi} and \code{sd} are replaced by the output of
\code{\link[=circular_summary]{circular_summary()}}.
}
\description{
Stress field interpolation and wavelength analysis using a kernel (weighted)
mean/median and standard deviation/IQR of stress data.
Parameters can be adjusted to have inverse-distance-weighting (IDW) or
nearest-neighbor interpolations (NN).
}
\details{
\code{\link[=stress2grid]{stress2grid()}} is originally based on the MATLAB script
"stress2grid" by Ziegler and Heidbach (2019):
\url{https://github.com/MorZieg/Stress2Grid}.
The tectonicr version has been significantly modified to provide better
performance and more flexibility.

\code{\link[=stress2grid_stats]{stress2grid_stats()}} is based on \code{\link[=stress2grid]{stress2grid()}} but calculates circular
summary statistics (see \code{\link[=circular_summary]{circular_summary()}}).
}
\examples{
data("san_andreas")

# Inverse Distance Weighting interpolation:
stress2grid(san_andreas, stat = "median") |> head()

stress2grid(san_andreas, stat = "tensor") |> head()

# Nearest Neighbor interpolation:
stress2grid(san_andreas, stat = "median", max_data = 5) |> head()

\dontrun{
stress2grid_stats(san_andreas) |> head()
}
}
\references{
Ziegler, M. and Heidbach, O. (2019).
Matlab Script Stress2Grid v1.1. GFZ Data Services. \doi{10.5880/wsm.2019.002}
}
\seealso{
\code{\link[=dist_greatcircle]{dist_greatcircle()}}, \code{\link[=PoR_stress2grid]{PoR_stress2grid()}}, \code{\link[=compact_grid]{compact_grid()}},
\code{\link[=circular_mean]{circular_mean()}}, \code{\link[=circular_median]{circular_median()}}, \code{\link[=circular_sd]{circular_sd()}}, \code{\link[=circular_summary]{circular_summary()}}
}
