% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/um.R
\name{display}
\alias{display}
\alias{display.um}
\alias{display.default}
\title{Graphs for ARMA models}
\usage{
display(um, ...)

\method{display}{um}(
  um,
  lag.max = 25,
  n.freq = 501,
  log.spec = FALSE,
  lags.at = NULL,
  graphs = c("acf", "pacf", "spec"),
  byrow = FALSE,
  eq = TRUE,
  cex = 1.25,
  ...
)

\method{display}{default}(um, ...)
}
\arguments{
\item{um}{an object of class \code{um} or a list of these objects.}

\item{...}{additional arguments.}

\item{lag.max}{number of lags for ACF/PACF.}

\item{n.freq}{number of frequencies for the spectrum.}

\item{log.spec}{logical. If TRUE log spectrum is computed.}

\item{lags.at}{the lags of the ACF/PACF at which tick-marks are to be drawn.}

\item{graphs}{vector of graphs.}

\item{byrow}{orientation of the graphs.}

\item{eq}{logical. If TRUE the model equation is used as title.}

\item{cex}{double. Font size for equation text.}
}
\description{
\code{display} shows graphs characterizing one or a list of ARMA models.
}
\examples{
um1 <- um(ar = "(1 - 0.8B)(1 - 0.8B^12)")
um2 <- um(ma = "(1 - 0.8B)(1 - 0.8B^12)")
display(list(um1, um2))

}
