% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tic_wor.R
\name{tic_wor}
\alias{tic_wor}
\title{Return wash out rate from time-intensity data}
\usage{
tic_wor(data, timevar, intensityvar, loess.span = 0.1, plotresult = FALSE, ...)
}
\arguments{
\item{data}{A dataframe with time and intensity values as columns.}

\item{timevar}{A character string (in quotes) with the dataframe column name for the time variable.}

\item{intensityvar}{A character string (in quotes) with dataframe column name for the intensity variable.}

\item{loess.span}{A number between 0 and 1, with larger values resulting in a smoother curve.}

\item{plotresult}{TRUE or FALSE to determine whether a plot of the results is generated.}

\item{...}{Additional arguments to be passed into the loess() function.}
}
\value{
The wash out rate (negative slope). If plotresult=TRUE also draws a plot.
}
\description{
This function returns the wash out rate from time-intensity curve data. Raw data
is smoothed using a loess smoother. Wash out rate is calculated as the absolute value of the most negative
slope of the loess curve after peak intensity is reached. A higher number
therefore refers to faster washout. It is recommended that
plotresult is set to TRUE in the first instance to visually confirm the analysis.
}
\examples{

# Example usage: Please see package vignettes on CRAN

}
