% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synth_spec.R
\name{synth_spec_extractor_api}
\alias{synth_spec_extractor_api}
\alias{add_custom_extractors}
\alias{update_custom_extractors}
\alias{remove_custom_extractors}
\title{Add, update, or remove extractors from a \code{synth_spec} object}
\usage{
add_custom_extractors(synth_spec, ...)

update_custom_extractors(synth_spec, ...)

remove_custom_extractors(synth_spec)
}
\arguments{
\item{synth_spec}{A \code{synth_spec} object}

\item{...}{Optional named lists with two elements, \code{vars} and \code{extractor},
mapping variable names to extractors.}
}
\value{
A new \code{synth_spec} object.

A new \code{synth_spec} object with added custom extractors.

A new \code{synth_spec} object with updated custom extractors.

A new \code{synth_spec} object with removed custom extractors.
}
\description{
Add, update, or remove extractors from a \code{synth_spec} object
}
\examples{

synth_spec <- synth_spec()

add_custom_extractors(
  synth_spec = synth_spec, 
  list("vars" = c("a", "b", "c"), "extractor" = parsnip::extract_fit_engine)
)


synth_spec <- synth_spec()

update_custom_extractors(
  synth_spec = synth_spec, 
  list("vars" = c("a", "b", "c"), "extractor" = parsnip::extract_fit_engine)
)


synth_spec <- synth_spec()

synth_spec <- add_custom_extractors(
  synth_spec = synth_spec, 
  list("vars" = c("a", "b", "c"), "extractor" = parsnip::extract_fit_engine)
)

remove_custom_extractors(synth_spec = synth_spec)

}
