% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fil_wavelet.R
\name{ts_fil_wavelet}
\alias{ts_fil_wavelet}
\title{Wavelet Filter}
\usage{
ts_fil_wavelet(filter = "haar")
}
\arguments{
\item{filter}{Available wavelet filters: 'haar', 'd4', 'la8', 'bl14', 'c6'.}
}
\value{
A \code{ts_fil_wavelet} object.
}
\description{
Denoise a series using discrete wavelet transforms and selected
wavelet families.
}
\examples{
# Denoising with discrete wavelets (optionally selecting best filter)
# Load package and example data
library(daltoolbox)
data(tsd)
tsd$y[9] <- 2 * tsd$y[9]  # inject an outlier

# Fit wavelet filter ("haar" by default; can pass a list to select best)
filter <- ts_fil_wavelet()
filter <- fit(filter, tsd$y)
y <- transform(filter, tsd$y)

# Compare original vs wavelet-denoised series
plot_ts_pred(y = tsd$y, yadj = y)
}
\references{
\itemize{
\item S. Mallat (1989). A Theory for Multiresolution Signal Decomposition:
The Wavelet Representation. IEEE Transactions on Pattern Analysis and
Machine Intelligence.
}
}
