% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbibinom.R
\name{dbibinom}
\alias{dbibinom}
\title{Probability Mass Function of Bivariate Binomial Distribution}
\usage{
dbibinom(N, y1, y2, p1, p2, rho)
}
\arguments{
\item{N}{Sample size (number of trials)}

\item{y1}{Observed value(s) of the first random variable (0 to N)}

\item{y2}{Observed value(s) of the second random variable (0 to N)}

\item{p1}{True probability of responders for the first outcome (0 < p1 < 1)}

\item{p2}{True probability of responders for the second outcome (0 < p2 < 1)}

\item{rho}{Correlation coefficient between the two binary outcomes}
}
\value{
Probability mass function value(s) for the bivariate binomial distribution.
If y1 and y2 are vectors, returns a vector of probabilities.
}
\description{
Calculates the probability mass function of the bivariate binomial distribution
for given parameters, as described in Homma and Yoshida (2025).
}
\details{
The bivariate binomial distribution BiBin(N, p1, p2, gamma) has probability mass
function given by equation (3) in Homma and Yoshida (2025):
\deqn{P(Y_1 = y_1, Y_2 = y_2) = f(y_1|N, p_1) \times g(y_2|y_1, N, p_1, p_2, \gamma)}
where
\deqn{g(y_2|y_1, N, p_1, p_2, \gamma) = \frac{1}{(1+\gamma)^N}
      \sum_{m \in \mathcal{M}} \binom{y_1}{m} \binom{N-y_1}{y_2-m}
      (\xi+\gamma)^m (1-\xi)^{y_1-m} \xi^{y_2-m} (1-\xi+\gamma)^{N-y_1-(y_2-m)}}
with \eqn{\xi = p_2 + \gamma(p_2 - p_1)} and
\eqn{\mathcal{M} = \{m : m = \max(0, y_2-(N-y_1)), \ldots, \min(y_1, y_2)\}}.
}
\examples{
# Calculate single probability mass
dbibinom(N = 100, y1 = 30, y2 = 50, p1 = 0.3, p2 = 0.5, rho = 0.5)

# Verify that probabilities sum to 1
N <- 20
p1 <- 0.3
p2 <- 0.5
rho <- 0.5
sum(outer(0:N, 0:N, function(x, y) dbibinom(N, x, y, p1, p2, rho)))

}
\references{
Homma, G., & Yoshida, T. (2025). Exact power and sample size in clinical
trials with two co-primary binary endpoints. \emph{Statistical Methods in
Medical Research}, 34(1), 1-19.
}
