% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session.R
\name{get_nordbord_tests_only}
\alias{get_nordbord_tests_only}
\title{Get only NordBord test data}
\usage{
get_nordbord_tests_only(start_date = NULL, profile_id = NULL)
}
\arguments{
\item{start_date}{(Optional) A UTC ISO 8601 datetime string (e.g. "2025-06-25T00:00:00Z") used to filter results by modification time. Input as a string.}

\item{profile_id}{(Optional) A specific profile ID to filter results for a single athlete. Input as a string.}
}
\value{
A data frame where each row corresponds to a NordBord test retrieved from the API. Returned invisibly.
}
\description{
Wrapper around \code{get_nordbord_tests()} to retrieve NordBord test data.
Intended for use when you want to fetch NordBord tests.
}
\examples{
\dontrun{
# Fetch all recent NordBord tests
tests <- get_nordbord_tests_only()
View(tests)

# Fetch NordBord tests for a specific profile
get_nordbord_tests_only(profile_id = "abcd1234-ab12-cd34-ef56-abcdef123456")
}
}
