% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_calculators.R
\name{calc_re}
\alias{calc_re}
\title{Calculate the effective reproduction number (Re)}
\usage{
calc_re(vc, disease, VE, r0_custom = NULL)
}
\arguments{
\item{vc}{Vaccination coverage rate (proportion, 0 to 1).}

\item{disease}{Character string: "Measles", "Pertussis", "Chickenpox", or "Custom".}

\item{VE}{Vaccine effectiveness (proportion, 0 to 1).}

\item{r0_custom}{The basic reproduction number (R0) for a custom disease.
Required only if `disease` is "Custom".}
}
\value{
The effective reproduction number (Re).
}
\description{
Calculate the effective reproduction number (Re)
}
\examples{
# For a standard disease
calc_re(vc = 0.92, disease = "Measles", VE = 0.97)
# For a custom disease like mumps (R0 approx. 10-12)
calc_re(vc = 0.88, disease = "Custom", VE = 0.85, r0_custom = 11)
}
