% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate.R
\name{interpolate.mdl_vtl_df}
\alias{interpolate.mdl_vtl_df}
\title{Interpolate missing values using a vital model}
\usage{
\method{interpolate}{mdl_vtl_df}(object, new_data, ...)
}
\arguments{
\item{object}{A mable containing a single model column.}

\item{new_data}{A dataset with the same structure as the data used to fit the model.}

\item{...}{Other arguments passed to interpolate methods.}
}
\value{
A vital object with missing values interpolated.
}
\description{
Uses a fitted vital model to interpolate missing values from a dataset.
}
\examples{
nor_female <- norway_mortality |>
  dplyr::filter(Sex == "Female")
nor_female |>
  model(mean = FMEAN(Mortality)) |>
  interpolate(nor_female)
}
\author{
Rob J Hyndman
}
