% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{model_metrics_plot}
\alias{model_metrics_plot}
\alias{model_plot}
\title{Plot regression coefficients}
\usage{
model_metrics_plot(
  data,
  col,
  categorical,
  metric,
  interactions = NULL,
  diagnostics = FALSE,
  labels = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A tibble.}

\item{col}{The target column holding metric values.}

\item{categorical}{A tidy column selection holding categorical variables.}

\item{metric}{A tidy column selection holding metric variables.}

\item{interactions}{A vector of interaction effects to calculate.
Each interaction effect should be provided as multiplication of the variables.
Example: \code{c(sd_gender * adopter)}.}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{effect_metrics}.}
}
\value{
A volker list object containing volker plots
}
\description{
The regression output comes from \code{stats::\link[stats:lm]{lm}}.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
library(volker)
data <- volker::chatgpt

data |>
  filter(sd_gender != "diverse") |>
  model_metrics_plot(use_work, categorical = c(sd_gender, adopter), metric = sd_age)

}
\keyword{internal}
