% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group.R
\docType{methods}
\name{[[.zarr_group}
\alias{[[.zarr_group}
\alias{[[,zarr-group-method}
\title{Get a group or array from a Zarr group}
\usage{
\method{[[}{zarr_group}(x, i)
}
\arguments{
\item{x}{A \code{zarr_group} object to extract a group or array from.}

\item{i}{The path to a group or array in \code{x}. The path is relative to the
group, it must not start with a slash "/". The path may start with any
number of double dots ".." separated by slashes "/" to denote groups
higher up in the hierarchy.}
}
\value{
An instance of \code{zarr_group} or \code{zarr_array}, or \code{NULL} if the path is
not found.
}
\description{
This method can be used to retrieve a group or array from the Zarr group by
a relative path to the desired group or array.
}
\examples{
z <- create_zarr()
z$add_group("/", "tst")
z$add_group("/tst", "subtst")
tst <- z[["/tst"]]
tst[["subtst"]]
}
