% System Rd macros

% These macros are automatically loaded whenever R processes an Rd file.

% Packages may define their own macros, which are stored in man/macros/*.Rd in
% the source, help/macros/*.Rd after installation.  Those will be processed after
% this file but before every Rd file in a package.

% Packages may request inclusion of macros from other packages using the 
% LoadRdMacros line in the DESCRIPTION file, e.g.
%  LoadRdMacros:  pkgA 
% These are loaded after the system macros and before the current package macros.

% Individual Rd files may define their own macros.


% To refer to a package on CRAN
\newcommand{\CRANpkg}{\href{https://CRAN.R-project.org/package=#1}{\pkg{#1}}}

% To refer to a bug report by number
\newcommand{\PR}{\Sexpr[results=rd]{tools:::Rd_expr_PR(#1)}}

% To avoid a double space after a period in LaTeX output
\newcommand{\sspace}{\ifelse{latex}{\out{~}}{ }}

% To get the package title at build time from the DESCRIPTION file
\newcommand{\packageTitle}{\Sexpr[results=rd,stage=build]{tools:::Rd_package_title("#1")}}

% To get the package description at build time from the DESCRIPTION file
\newcommand{\packageDescription}{\Sexpr[results=rd,stage=build]{tools:::Rd_package_description("#1")}}

% To get the package author at build time from the DESCRIPTION file
\newcommand{\packageAuthor}{\Sexpr[results=rd,stage=build]{tools:::Rd_package_author("#1")}}

% To get the package maintainer at build time from the DESCRIPTION file
\newcommand{\packageMaintainer}{\Sexpr[results=rd,stage=build]{tools:::Rd_package_maintainer("#1")}}

% To get a formatted copy of the whole DESCRIPTION file
\newcommand{\packageDESCRIPTION}{\Sexpr[results=rd,stage=build]{tools:::Rd_package_DESCRIPTION("#1")}}

% To include various indices about an installed package
\newcommand{\packageIndices}{\Sexpr[results=rd,stage=build]{tools:::Rd_package_indices("#1")}}

% To indicate a DOI.
\newcommand{\doi}{\Sexpr[results=rd]{tools:::Rd_expr_doi("#1")}}

% To indicate LaTeX.
\newcommand{\LaTeX}{\ifelse{latex}{\out{{\LaTeX}}}{LaTeX}}

% To indicate a programming language.
% Ideally this would also do something like
%   \ifelse{html}{\out{<span style="font-family: sans-serif;">#1</span>}}
% but this does not always work correctly with Rd2HTML() as of 2018-05.
\newcommand{\proglang}{\ifelse{latex}{\out{\textsf{#1}}}{#1}}

% To get things ignored by RdTextFilter() ...
\newcommand{\I}{#1}

% To cite an R manual, e.g.: \manual{R-exts}{Processing documentation files}
\newcommand{\manual}{\Sexpr[results=rd]{tools:::Rd_expr_manual("#1", "#2")}}

\newcommand{\bibcitep}{\Sexpr[results=rd,stage=build]{tools:::Rd_expr_bibcite("#1", FALSE)}}
\newcommand{\bibcitet}{\Sexpr[results=rd,stage=build]{tools:::Rd_expr_bibcite("#1", TRUE)}}
\newcommand{\bibshow}{\Sexpr[results=rd,stage=build]{tools:::Rd_expr_bibshow("#1")}}
\newcommand{\bibinfo}{\Sexpr[stage=build]{tools:::Rd_expr_bibinfo("#1", "#2", "#3")}}
