% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamlss.R
\name{gamlss.gH}
\alias{gamlss.gH}
\title{Calculating derivatives of log-likelihood wrt regression coefficients}
\usage{
gamlss.gH(X, jj, l1, l2, i2, l3 = 0, i3 = 0, l4 = 0, i4 = 0, d1b = 0,
  d2b = 0, deriv = 0, fh = NULL, D = NULL,sandwich=FALSE)
}
\arguments{
\item{X}{matrix containing the model matrices of all the linear predictors.}

\item{jj}{list of index vectors such that \code{X[,jj[[i]]]} is the model matrix of the i-th linear predictor.}

\item{l1}{array of 1st order derivatives of each element of the log-likelihood wrt each parameter.}

\item{l2}{array of 2nd order derivatives of each element of the log-likelihood wrt each parameter.}

\item{i2}{two-dimensional index array, such that \code{l2[,i2[i,j]]} contains the partial w.r.t. params 
indexed by i,j with no restriction on the index values (except that they are in 1,...,ncol(l1)).}

\item{l3}{array of 3rd order derivatives of each element of the log-likelihood wrt each parameter.}

\item{i3}{third-dimensional index array, such that \code{l3[,i3[i,j,k]]} contains the partial w.r.t. params 
indexed by i,j,k.}

\item{l4}{array of 4th order derivatives of each element of the log-likelihood wrt each parameter.}

\item{i4}{third-dimensional index array, such that \code{l4[,i4[i,j,k,l]]} contains the partial w.r.t. params 
indexed by i,j,k,l.}

\item{d1b}{first derivatives of the regression coefficients wrt the smoothing parameters.}

\item{d2b}{second derivatives of the regression coefficients wrt the smoothing parameters.}

\item{deriv}{if \code{deriv==0} only first and second order derivatives will be calculated. If
\code{deriv==1} the function return also the diagonal of the first derivative of the Hessian,
if \code{deriv==2} it return the full 3rd order derivative and if \code{deriv==3} it provides
also 4th order derivatives.}

\item{fh}{eigen-decomposition or Cholesky factor of the penalized Hessian.}

\item{D}{diagonal matrix, used to provide some scaling.}

\item{sandwich}{set to \code{TRUE} to return sandwich estimator 'filling', as opposed to the Hessian, in \code{l2}.}

}
\value{
A list containing \code{lb} - the grad vector w.r.t. coefs; \code{lbb} - the Hessian matrix w.r.t. coefs;
\code{d1H} - either a list of the derivatives of the Hessian w.r.t. the smoothing parameters, or a single matrix whose columns are the leading diagonals of these dervative matrices; \code{trHid2H} - the trace of the inverse Hessian multiplied by the second derivative of the Hessian w.r.t. all combinations of smoothing parameters.
}
\description{ Mainly intended for internal use with location scale model families.
Given the derivatives of the log-likelihood wrt the linear predictor, this function obtains
             the derivatives and Hessian wrt the regression coefficients and derivatives of
	     the Hessian w.r.t. the smoothing parameters. For input derivative array packing conventions see \code{\link{trind.generator}}.
}

\seealso{ \code{\link{trind.generator}}}
\author{
Simon N. Wood <simon.wood@r-project.org>.
}

