% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh.R
\name{compute_mh_y_pps__severity_score}
\alias{compute_mh_y_pps__severity_score}
\title{Compute "Prodromal Psychosis Scale [Youth] (Severity Score)"}
\usage{
compute_mh_y_pps__severity_score(
  data,
  name = "mh_y_pps__severity_score",
  max_na = 0,
  combine = TRUE
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{name}{character. Name of the summary score column.}

\item{max_na}{numeric, positive whole number. Number of missing items
allowed. \code{NULL} means no limit.}

\item{combine}{logical. If \code{TRUE} (default), the summary score is
is appended as a new column to the input data frame. If \code{FALSE}, the
summary score is returned as a separate one-column data frame.}
}
\value{
tbl. see \code{combine}.
}
\description{
Computes the summary score \code{mh_y_pps__severity_score}
Prodromal Psychosis Scale [Youth] (Severity Score)
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_y_pps__severity_001}
\item \code{mh_y_pps__severity_002}
\item \code{mh_y_pps__severity_003}
\item \code{mh_y_pps__severity_004}
\item \code{mh_y_pps__severity_005}
\item \code{mh_y_pps__severity_006}
\item \code{mh_y_pps__severity_007}
\item \code{mh_y_pps__severity_008}
\item \code{mh_y_pps__severity_009}
\item \code{mh_y_pps__severity_010}
\item \code{mh_y_pps__severity_011}
\item \code{mh_y_pps__severity_012}
\item \code{mh_y_pps__severity_013}
\item \code{mh_y_pps__severity_014}
\item \code{mh_y_pps__severity_015}
\item \code{mh_y_pps__severity_016}
\item \code{mh_y_pps__severity_017}
\item \code{mh_y_pps__severity_018}
\item \code{mh_y_pps__severity_019}
\item \code{mh_y_pps__severity_020}
\item \code{mh_y_pps__severity_021}
}
\item \emph{Excluded values:} none
\item \emph{Validation criterion:} none of 21 items missing
}
}
\details{
The severity score is calculated by summing the severity scores for each
question and adding the number of \code{mh_y_pps__bother__yes_count} to the
total.

However, if the \code{mh_y_pps__severity_nm} score is greater than \code{max_na},
the severity score is set to \code{NA}.

There is also a sanity check for the gating question of PPS
base/bother score. If the paired base/bother question is 0 or \code{NA}
and the severity score is not missing, the paired severity score is set
to \code{NA} before computing the score.
}
\examples{
\dontrun{
compute_mh_y_pps__severity_score(data) |>
  select(
    any_of(c("mh_y_pps__severity_score", vars_mh_y_pps__severity))
  ) |>
  View()
}
}
\seealso{
\code{\link[=compute_mh_y_pps__bother__yes_count]{compute_mh_y_pps__bother__yes_count()}}
}
