% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LSDTest.R
\name{LSDTest}
\alias{LSDTest}
\title{Least Significant Difference (LSD) Test}
\usage{
LSDTest(modelo, alpha = 0.05)
}
\arguments{
\item{modelo}{An object of class \code{aov} or \code{lm}.}

\item{alpha}{Significance level (default is 0.05).}
}
\value{
An object of class \code{"comparaciones"} with LSD results.
}
\description{
Performs unadjusted pairwise t-tests following a significant ANOVA.
}
\details{
Advantages:
- Very powerful when assumptions are met.
- Simple and easy to interpret.

Disadvantages:
- High risk of Type I error without correction.
- Not recommended if many comparisons are made.
}
\examples{
data(d_e, package = "Analitica")
mod <- aov(Sueldo_actual ~ as.factor(labor), data = d_e)
resultado <- LSDTest(mod)
summary(resultado)
plot(resultado)

}
\references{
Fisher, R. A. (1935). The Design of Experiments. Oliver & Boyd.
}
